import {BrowserModule} from '@angular/platform-browser';
import {NgModule} from '@angular/core';

import {AppComponent} from './app.component';
import {AppRoutingModule} from './app-routing.module';
import {BrokerQryComponent} from './broker-qry/broker-qry.component';
import {BrokerDetailComponent} from './broker-detail/broker-detail.component';
import {MobileNoFormatPipe} from './mobile-no-format.pipe';
import {HashLocationStrategy, LocationStrategy} from '@angular/common';
import {FormsModule} from '@angular/forms';
import {HttpClientModule} from '@angular/common/http';
import {EventBusService} from './event-bus.service';

@NgModule({
  declarations: [
    AppComponent,
    BrokerQryComponent,
    BrokerDetailComponent,
    MobileNoFormatPipe
  ],
  imports: [
    BrowserModule,
    FormsModule,
    HttpClientModule,
    AppRoutingModule
  ],
  providers: [{provide: LocationStrategy, useClass: HashLocationStrategy}, EventBusService],
  bootstrap: [AppComponent]
})
export class AppModule {
}
