import {NgModule} from '@angular/core';
import {Routes, RouterModule} from '@angular/router';
import {TransitComponent} from './transit/transit.component';
import {FamilyComponent} from './family/family.component';
import {AgeComponent} from './age/age.component';
import {JobComponent} from './job/job.component';
import {IncomeComponent} from './income/income.component';
import {LoanComponent} from './loan/loan.component';
import {SocialSecurityComponent} from './social-security/social-security.component';
import {HealthComponent} from './health/health.component';
import {ChildrenHealthComponent} from './children-health/children-health.component';
import {DiseaseComponent} from './disease/disease.component';
import {SmokingComponent} from './smoking/smoking.component';
import {LiveComponent} from './live/live.component';

const routes: Routes = [
  {
    path: '',
    redirectTo: '/index',
    pathMatch: 'full'
  }, {
    path: 'index',
    component: TransitComponent
  }, {
    path: 'family',
    component: FamilyComponent
  }, {
    path: 'age',
    component: AgeComponent
  }, {
    path: 'job',
    component: JobComponent,
    data: [{type: 1}]
  }, {
    path: 'spouse_job',
    component: JobComponent,
    data: [{type: 2}]
  }
  , {
    path: 'income',
    component: IncomeComponent
  }, {
    path: 'loan',
    component: LoanComponent
  }, {
    path: 'social',
    component: SocialSecurityComponent
  }, {
    path: 'health',
    component: HealthComponent
  }, {
    path: 'health',
    component: HealthComponent,
    data: [{type: 1}]
  }, {
    path: 'spouse_health',
    component: HealthComponent,
    data: [{type: 2}]
  }, {
    path: 'children_health',
    component: ChildrenHealthComponent,
  }, {
    path: 'disease',
    component: DiseaseComponent
  }, {
    path: 'smoke',
    component: SmokingComponent
  }, {
    path: 'live',
    component: LiveComponent
  }, {
    path: '*',
    component: 'TransitComponent'
  }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule {
}
