import {Component, OnInit} from '@angular/core';
import {CommonService} from '../common.service';
import {Router, ActivatedRoute} from "@angular/router";
@Component({
  selector: 'app-job',
  templateUrl: './job.component.html',
  styleUrls: ['./job.component.css']
})
export class JobComponent implements OnInit {
  curPageData: Array<any>;
  pageAnswers: any;
  selectedOptionId: any;
  type: any;
  id:any;
  nextBtn:boolean;
  constructor(private commonService: CommonService, 
    private router: Router,
    private route: ActivatedRoute) {
     /**
     * 1:单身贵族
     * 2：二人世界
     * 3：独立带娃
     * 4：多口之家
     * @type {any}
     */
    /**
     * 1：您的工作
     * 2: 配偶的工作
     * @id
     *  */
    this.type = this.route.snapshot.queryParams['type'];
    this.id = this.route.snapshot['data']['0']['id'];
    console.log(this.id)
    this.pageAnswers = {
      pageId: '',
      questions: [{
        questionId: '',
        questionName: '',
        options: [{optionId: '', optionName: '', optionOrder: '', selected: ''}]
      }],
    };
  }

  ngOnInit() {
    this.nextBtn = false;
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        if (this.id == 1) {
          this.curPageData = res['data'].survey.pages['3'];
        } else {
          this.curPageData = res['data'].survey.pages['4'];
          
        }
        console.log(this.curPageData)
      }
    });
  }

  selectedJob(option) {
    console.log(this.curPageData['pageId'])
    this.selectedOptionId = option.optionId;
    option.selected = true;
    this.pageAnswers = {
      pageId: this.curPageData['pageId'],
      questions: [{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options: [option]
      }],
    };
    this.commonService.addAnswer(this.pageAnswers);
    console.log(this.pageAnswers)
    console.log(this.commonService.todos)
    if(this.pageAnswers['questions'].length>0){
      this.nextBtn = true;
    }else{
      this.nextBtn = false;
    }
  }

  //   下一步
  next() {
    //先判断下一步能不能点
    //如果是二人世界或是多口之家跳转到配偶页
    //先判断当前页是您的页还是配偶页
    if(this.nextBtn ==true){
      if(this.id == 1){
        if(this.type ==2 || this.type==4){
          this.router.navigate(['/spouse_job'],{queryParams:{type:this.type}})
        }else{
          this.router.navigate(['/transit1'],{queryParams:{type:this.type}})
        }
      }else{
        this.router.navigate(['/transit1'],{queryParams:{type:this.type}})
      }
    }else{
      return;
    }
    
    
  }
}
