import { Component, OnInit } from '@angular/core';
import {CommonService} from '../common.service';
import {ActivatedRoute, Router} from "@angular/router";

@Component({
  selector: 'app-disease',
  templateUrl: './disease.component.html',
  styleUrls: ['./disease.component.css']
})
export class DiseaseComponent implements OnInit {
  curPageData:Array<any>;
  type:any;
  pageAnswers:any;
  nextBtn:boolean;
  options:Array<any>;
  selectedOptionId:any;
  questions:Array<any> = [];
  constructor(
    private commonService: CommonService,
    private router: Router, 
    private route: ActivatedRoute
  ) { 
    this.type = this.route.snapshot.queryParams['type'];
    this.pageAnswers = {
      pageId: '',
      questions: [{
        questionId: '',
        questionName: '',
        options: [{optionId: '', optionName: '', optionOrder: '', selected: ''}]
      }],
    };
  }

  ngOnInit() {
    this.nextBtn = false;
    this.surveyInfo()
  }
  surveyInfo() {
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['13']
        /**
         * 1:单身贵族
         * 2：二人世界
         * 3：独立带娃
         * 4：多口之家
         * @type {any}
         */
        //过滤选项
        if(this.type == 1){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 106 || option.optionId == 107
          })
        }
        if(this.type == 2){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 108 || option.optionId == 109 || option.optionId == 111
          })
        }
        if(this.type == 3){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 108 || option.optionId == 110 || option.optionId == 111
          })
        }
        if(this.type == 4){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 108 || option.optionId == 109 || option.optionId == 110 || option.optionId == 111
          })
        }
      }
    })
  }

  getOneAnswer(option){
    for(let i=0;i<this.options.length;i++){
      if(option['optionId']==this.options[i]['optionId']){
        this.options[i]['selected'] = true;
      }else{
        this.options[i]['selected'] = false;
      }
    }
    this.pageAnswers = {
      pageId : this.curPageData['pageId'],
      questions:[{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options:[option]
      }]
    }
    this.commonService.addAnswer(this.pageAnswers)
    console.log(this.pageAnswers)
    if(this.pageAnswers['questions'].length>0){
      this.nextBtn = true
    }else{
      this.nextBtn = false
    }
  }
  getManyAnswer(option){
    option['selected'] = !option['selected'];
    this.questions = [];
    for (let i = 0; i < this.curPageData['questions'][0]['options'].length; i++) {
      if (option.optionId == 111 && option['selected']) {
        this.curPageData['questions'][0]['options'][i]['selected'] = false;
        if (this.curPageData['questions'][0]['options'][i]['optionId'] == 111) {
          this.curPageData['questions'][0]['options'][i]['selected'] = true;
        }
      } else {
        if (this.curPageData['questions'][0]['options'][i]['optionId'] == 111) {
          this.curPageData['questions'][0]['options'][i]['selected'] = false;
        }
      }
      // 拿到所有selected为true的选项
      if (this.curPageData['questions'][0]['options'][i]['selected']) {
        this.questions.push(this.curPageData['questions'][0]['options'][i]);
      }
    }
    this.pageAnswers = {
      pageId: this.curPageData['pageId'],
      questions: [{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options: this.questions
      }],
    };
    if(this.pageAnswers['questions'].length>0){
      this.nextBtn = true
    }else{
      this.nextBtn = false
    }
    console.log(this.pageAnswers)
    this.commonService.addAnswer(this.pageAnswers);
  }
  //根据type区分单选多选
  checkFun(option){
    if(this.type==1){
      this.getOneAnswer(option)
    }else{
      this.getManyAnswer(option)
    }
  }
  next(){
    if(this.nextBtn == true){
      this.router.navigate(['/smoke'],{queryParams:{type:this.type}})
    }else{
      return
    }
  }
}
