import {Injectable} from '@angular/core';
import {environment} from './../environments/environment';
import {HttpClient, HttpErrorResponse, HttpHeaders} from '@angular/common/http';
import { Observable, throwError } from 'rxjs';
import { catchError, retry } from 'rxjs/operators';
@Injectable({
  providedIn: 'root'
})
export class EventBusService {
  private USER_API_URL = '';

  constructor(private http: HttpClient) {
    this.USER_API_URL = environment.apiUrl;
  }

  /**
   * 获取TOKEN
   */
  obtainToken() {
    const url = this.USER_API_URL + '/authorize/obtainToken';
    const ticketObj = {
      ticket: 'brokerQry'
    };
    return this.http.post(url, JSON.stringify(ticketObj),{ observe: 'response' })
      .pipe(
        response => {
          return response;
        }
      );
  }

  /**
   * 错误信息处理
   * @param error
   * @returns {Observable<never>}
   */
  private handleError(error: HttpErrorResponse) {
    if (error.error instanceof ErrorEvent) {
      // A client-side or network error occurred. Handle it accordingly.
      console.error('An error occurred:', error.error.message);
    } else {
      // The backend returned an unsuccessful response code.
      // The response body may contain clues as to what went wrong,
      console.error(
        `Backend returned code ${error.status}, ` +
        `body was: ${error.error}`);
    }
    // return an observable with a user-facing error message
    return throwError(
      'Something bad happened; please try again later.');
  };

}
