import { Component, OnInit } from '@angular/core';
import { CommonService } from "../common.service";

@Component({
  selector: 'app-transit',
  templateUrl: './transit.component.html',
  styleUrls: ['./transit.component.css']
})
export class TransitComponent implements OnInit {
  picFlag: boolean;
  constructor(private commonService: CommonService) {
  }

  ngOnInit() {
    this.commonService.surveyInfo().then();
    const activityCode = this.commonService.getQueryString('activityCode');
    if (activityCode == 'mmh') {
      this.picFlag = true;
      sessionStorage.setItem('activityCode', activityCode);
    } else {
      this.picFlag = false;
    }
  }
}
