import { Component, OnInit } from '@angular/core';
import { CommonService } from '../common.service';
import { ActivatedRoute, Router } from "@angular/router";

@Component({
  selector: 'app-income',
  templateUrl: './income.component.html',
  styleUrls: ['./income.component.css']
})
export class IncomeComponent implements OnInit {
  curPageData: any;
  pageAnswers: any;
  // 家庭结构
  type: any;
  nextBtn: boolean;
  lastQuestions: Array<any>;
  targetObj: Object = {}
  constructor(private commonService: CommonService,
    private router: Router,
    private route: ActivatedRoute) {
    /**
     * 1:单身贵族
     * 2：二人世界
     * 3：独立带娃
     * 4：多口之家
     * @type {any}
     */
    this.type = this.route.snapshot.queryParams['type'];
    this.pageAnswers = {
      pageId: '',
      questions: [],
    };
  }

  ngOnInit() {
    this.nextBtn = false;
    this.lastQuestions = this.commonService.todosCopy.filter(item => item.pageId == 7).pop();
    this.surveyInfo();
  }

  surveyInfo() {
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['6'];
        this.pageAnswers.pageId = this.curPageData['pageId'];
        if (this.lastQuestions) {
          for (let i = 0; i < this.lastQuestions['questions'].length; i++) {
            for (let j = 0; j < this.curPageData['questions'].length; j++) {
              if (this.lastQuestions['questions'][i].questionId == this.curPageData['questions'][j].questionId) {
                this.lastQuestions['questions'][i]['options'].forEach(option => {
                  if (Object.keys(option).indexOf('optionId') > -1) {
                    this.targetObj = option
                  }
                  this.selectedIncome(this.curPageData['questions'][j], this.targetObj, 'isReturn');
                });
              }
            }
          }
        } else {
          return;
        }
      }
    })
  }

  selectedIncome(question, option, isReturn?: any) {
    option.selected = !option.selected;
    const questions = {
      questionId: question.questionId,
      questionName: question.questionName,
      options: []
    };
    // 将选择的状态改为true,其他的改为false;
    if (question['options'].length > 0) {
      for (let j = 0; j < question['options'].length; j++) {
        if (question['options'][j].optionId == option.optionId) {
          question['options'][j].selected = true;
        } else {
          question['options'][j].selected = false;
        }
        // 拿到所有selected为true的选项
        if (question['options'][j]['selected']) {
          questions.options.push(question['options'][j]);
        }
      }
    }
    // 同一个问题更改答案
    for (let i = 0; i < this.pageAnswers.questions.length; i++) {
      if (this.pageAnswers.questions[i].questionId == question.questionId) {
        const index = this.pageAnswers.questions.indexOf(this.pageAnswers.questions[i]);
        this.pageAnswers.questions.splice(index, 1);
      }
    }
    this.pageAnswers.questions.push(questions);
    this.commonService.addAnswer(this.pageAnswers);
    // 判断页面需要几个问题
    if (this.type == 2 || this.type == 4) {
      if (this.curPageData['questions'].length == this.pageAnswers['questions'].length) {
        this.nextBtn = true;
      } else {
        this.nextBtn = false;
      }
    } else {
      if (this.pageAnswers['questions'].length > 0) {
        this.nextBtn = true;
      } else {
        this.nextBtn = false;
      }
    }
    if (!isReturn) {
      this.next()
    }
  }

  next() {
    if (this.nextBtn == true) {
      this.router.navigate(['/loan'], { queryParams: { type: this.type } })
    } else {
      return;
    }
  }

  //  上一步
  before() {
    this.commonService.before();
  }
}
