import {Component, ElementRef, OnInit, ViewChild} from '@angular/core';
import {EventBusService} from '../event-bus.service';
import {ActivatedRoute} from '@angular/router';

@Component({
  selector: 'app-broker-detail',
  templateUrl: './broker-detail.component.html',
  styleUrls: ['./broker-detail.component.css']
})
export class BrokerDetailComponent implements OnInit {
  certificateList: Array<any>;
  lifePhotoList: Array<any>;
  practitionerId: any;
  userPractitionerInfo: any;
  imgShowFlag: boolean;
  scaleImgPath: any;
  reloadurl:any;
  constructor(private eventBusService: EventBusService, private activatedRoute: ActivatedRoute) {
  }

  ngOnInit() {
    this.practitionerId = this.activatedRoute.snapshot.params['id'];
    this.userPractitionerDetailQuery();
    this.reloadurl = window.location.hash + 'reload=true';
    if (this.getQuery('reload') !== 'true') {
      window.location.href = this.reloadurl;
    }
  }
  userPractitionerDetailQuery() {
    const practitionerId = {
      practitionerId: this.practitionerId
    };
    this.eventBusService.userPractitionerDetailQuery(practitionerId).then(res => {
      if (res['success']) {
        this.userPractitionerInfo = res['data'];
        this.certificateList = this.userPractitionerInfo.certificateList;
        this.lifePhotoList = this.userPractitionerInfo.lifePhotoList;
      }
    });
  }

  scaleImg(path) {
    this.scaleImgPath = path;
    this.imgShowFlag = true;
  }

  getQuery(name) {
    const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
    const r = decodeURIComponent(window.location.search).substr(1).match(reg);
    if (r != null) {
      return r[2];
    }
    return null;
  }
}
