var namereg = /^[a-zA-Z\u4e00-\u9fa5 ]{1,20}$/;
var phonereg = /^[1][3,4,5,7,8][0-9]{9}$/;
var expressreg = /^[京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领A-Z]{1}[A-Z]{1}[A-Z0-9]{4}[A-Z0-9挂学警港澳]{1}$/;
var carReg = /^[0-9a-zA-Z]+$/;
laydate.render({
    elem: '#registrationDate',
    format: 'yyyy-MM-dd',
    max: getNowFormatDate()
});
laydate.render({
    elem: '#renewalDate',
    format: 'yyyy-MM-dd',
    min: getNowFormatDate()
});
// 判断localStorage 是否有token
if (localStorage.getItem('token')) {
    var objParams = {
        token: localStorage.getItem('token')
    };
    $.ajax({
        type: "post",
        contentType: 'application/json;charset=UTF-8',
        url: "https://mdev.zuihuibi.cn/api/authorize/checkToken",
        dataType: "json",
        async: false,
        data: JSON.stringify(objParams),
        beforeSend: function(request) {
            request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
        },
        success: function (data) {
            if (data.success) {

            } else {
                getToken();
            }
        },
        error: function (xhr, status, error) {

        }
    })
} else {
    getToken();
}

$("#btnSave").click(function () {
    // 验证必填项
    var name = $("#ownerName").val();
    var ownerPhone = $("#ownerPhone").val();
    var ownerNumber = $("#ownerNumber").val();

    var IDNumber = $("#IDNumber").val();
    var insuranceCompany = $("#insuranceCompany").val();
    var introducer = $("#introducer").val();
    var introducerPhone = $("#introducerPhone").val();
    var provinceId = $('#province option:selected').val();
    var registrationProvince = '';
    if (provinceId != '') {
        registrationProvince = $('#province option:selected').text();
    }
    var registrationCity = "";
    var cityId = $('#city option:selected').val();
    if (cityId != '') {
        registrationCity = $('#city option:selected').text();
    }
    var registrationDate = $("#registrationDate").val();
    var purchasePrice = $("#purchasePrice").val();
    var insurer = $("#insuranceCompany").val();
    var compulsoryInsFee = $("#accidentsInsurance").val();
    var commercialInsFee = $("#commercialInsurance").val();
    var renewalDate = $("#renewalDate").val();
    var introducer = $("#introducer").val();
    var introducerPhone = $("#introducerPhone").val();
    var introducerWechat = $("#introducerWechart").val();
    var carNumber = $("#carNumber").val();
    var ownerWechat = $("#ownerWechat").val();
    if (name != '') {
        // 验证姓名是否合法
        if (!namereg.test(name)) {
            layer.msg("请正确输入您的姓名！");
            return;
        }
    } else {
        layer.msg("请输入您的姓名！");
        return;
    }
    if (ownerPhone != '') {
        if (!phonereg.test(ownerPhone)) {
            layer.msg("请正确输入您的手机号码！");
            return;
        }
    } else {
        layer.msg("请输入您的手机号码！");
        return;
    }
    // 身份证号码验证
    if (IDNumber != "") {
        if (!IdCodeValid(IDNumber).pass) {
            layer.msg("请正确输入您的身份证号码！");
            return;
        }
    }
    if (ownerNumber != '') {
        if (!expressreg.test(ownerNumber)) {
            layer.msg("请正确输入您的车牌号！");
            return;
        }
    } else {
        layer.msg("请输入您的车牌号！");
        return;
    }
    if (carNumber != '') {
        if (!carReg.test(carNumber)) {
            layer.msg("请正确输入您的VIN！");
            return;
        }
    }

    if (insuranceCompany != '') {
        if (!namereg.test(insuranceCompany)) {
            layer.msg("请正确输入您的车辆目前受保险公司！");
            return;
        }
    }
    if (introducer != '') {
        if (!namereg.test(introducer)) {
            layer.msg("请正确输入推荐人姓名！");
            return;
        }
    }
    if (introducerPhone != '') {
        if (!checkTel(introducerPhone)) {
            layer.msg("请正确输入推荐人电话！");
            return;
        }
    }
    // 提交成功设置不可编辑
    var saveData = {
        ownerName: name,
        phoneNo: ownerPhone,
        idNo: IDNumber,
        plateNo: ownerNumber,
        registrationProvince: registrationProvince,
        provinceId: provinceId,
        registrationCity: registrationCity,
        cityId: cityId,
        registrationDate: registrationDate,
        purchasePrice: delcommafy(purchasePrice),
        insurer: insurer,
        compulsoryInsFee: delcommafy(compulsoryInsFee),
        commercialInsFee: delcommafy(commercialInsFee),
        renewalDate: renewalDate,
        introducer: introducer,
        introducerPhone: introducerPhone,
        introducerWechat: introducerWechat,
        wechatId: ownerWechat,
        vinNo: carNumber
    };
    // 查询入参
    var searchData = {
        plateNo: ownerNumber,
        ownerName: name,
        phoneNo: ownerPhone,
        idNo: IDNumber,
        registrationProvince: registrationProvince
    };
    $.ajax({
        type: 'POST',
        contentType: 'application/json;charset=UTF-8',
        dataType: 'json',
        url: "https://mdev.zuihuibi.cn/api/vehicleSave",
        data: JSON.stringify(saveData),
        beforeSend: function(request) {
            request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
        },
        success: function (d) {
            if (d.success) {
                layer.msg("提交成功,我们的保险经纪人会尽快和你取得联系!");
                $("input[type=text]").attr('disabled', true);
                $("input[type=number]").attr('disabled', true);
                $("#province").attr("disabled", true);
                $("#city").attr("disabled", true);
                $("#btnSave").hide();
                $(".btnSubmit .btnEdit").show();
                var cityValue = '';
                var provinceValue = '';
                // 走查询接口
                $.ajax({
                    type: 'POST',
                    contentType: 'application/json;charset=UTF-8',
                    dataType: 'json',
                    url: "https://mdev.zuihuibi.cn/api/vehicleQuery",
                    data: JSON.stringify(searchData),
                    beforeSend: function(request) {
                        request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
                    },
                    success: function (res) {
                        if (res.success) {
                            // 存入隐藏标签
                            $("#personName").val(name);
                            $("#personPhone").val(ownerPhone);
                            $("#personCar").val(ownerNumber);

                            $("#ownerName").val(res.data.ownerName);
                            $("#ownerPhone").val(res.data.phoneNo);
                            $("#ownerNumber").val(res.data.plateNo);
                            $("#vehicleId").val(res.data.vehicleId);
                            if (res.data.idNo) {
                                $("#IDNumber").val(res.data.idNo);
                            }
                            if (res.data.registrationDate) {
                                $("#registrationDate").val(res.data.registrationDate);
                            }
                            if (res.data.purchasePrice) {
                                $("#purchasePrice").val(res.data.purchasePrice);
                            }
                            if (res.data.insurer) {
                                $("#insuranceCompany").val(res.data.insurer);
                            }
                            if (res.data.compulsoryInsFee) {
                                $("#accidentsInsurance").val(res.data.compulsoryInsFee);
                            }
                            if (res.data.commercialInsFee) {
                                $("#commercialInsurance").val(res.data.commercialInsFee);
                            }
                            if (res.data.renewalDate) {
                                $("#renewalDate").val(res.data.renewalDate);
                            }
                            if (res.data.introducer) {
                                $("#introducer").val(res.data.introducer);
                            }
                            if (res.data.introducerPhone) {
                                $("#introducerPhone").val(res.data.introducerPhone);
                            }
                            if (res.data.introducerWechat) {
                                $("#introducerWechart").val(res.data.introducerWechat);
                            }
                            if (res.data.provinceId) {
                                $("#province").val(res.data.provinceId);
                                provinceValue = res.data.provinceId;
                            }
                            if (res.data.cityId) {
                                cityValue = res.data.cityId;
                            }
                            if (res.data.wechatId) {
                                $("#ownerWechat").val(res.data.wechatId);
                            }
                            if (res.data.vinNo) {
                                $("#carNumber").val(res.data.vinNo);
                            }
                            var data1 = {};
                            if (provinceValue != '') {
                                $.ajax({
                                    type: 'POST',
                                    contentType: 'application/json;charset=UTF-8',
                                    dataType: 'json',
                                    url: "https://mdev.zuihuibi.cn/api/metadata/provCityQry",
                                    data: JSON.stringify(data1),
                                    beforeSend: function(request) {
                                        request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
                                    },
                                    success: function (d) {
                                        var list = d.data.provinces;
                                        for (var i = 0; i < list.length; i++) {
                                            if (list[i].provinceId == provinceValue) {
                                                var cityList = list[i].citys;
                                                $("#city").empty();
                                                for (var j = 0; j < cityList.length; j++) {
                                                    $("#city").append('<option value="' + cityList[j].cityId + '">' + cityList[j].cityName + '</option>');
                                                }
                                            }
                                        }
                                        $("#city").val(cityValue);
                                    }
                                })
                            }
                        } else {
                            layer.msg(res.data.message);
                        }
                    }
                })
            } else {
                layer.msg("保存失败！");
            }
        }
    })
})
// 编辑
$(".btnSubmit .btnEdit").click(function () {
    $(".btnSubmit .btnEdit").hide();
    $(".wrap .btnConfrim").show();
    $("input[type=text]").attr('disabled', false);
    $("input[type=number]").attr('disabled', false);
    $("#province").attr("disabled", false);
    $("#city").attr("disabled", false);
})
// 取消编辑
$(".wrap .cancel").click(function () {
    $("input[type=text]").attr('disabled', true);
    $("input[type=number]").attr('disabled', true);
    $("#province").attr("disabled", true);
    $("#city").attr("disabled", true);
    $("#btnSave").hide();
    $(".btnSubmit .btnEdit").show();
    $(".wrap .btnConfrim").hide();
    // 查询一次
    var name = $("#personName").val();
    var ownerNumber = $("#personCar").val();
    var ownerPhone = $("#personPhone").val();
    // var IDNumber = $("#IDNumber").val();
    // var registrationProvince = $('#province option:selected').text();
    // 查询入参
    var searchData = {
        plateNo: ownerNumber,
        ownerName: name,
        phoneNo: ownerPhone
        // idNo: IDNumber,
        // registrationProvince: registrationProvince
    };
    var cityValue = '';
    var provinceValue = '';
    $.ajax({
        type: 'POST',
        contentType: 'application/json;charset=UTF-8',
        dataType: 'json',
        url: "https://mdev.zuihuibi.cn/api/vehicleQuery",
        data: JSON.stringify(searchData),
        beforeSend: function(request) {
            request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
        },
        success: function (res) {
            if (res.success) {
                $("#ownerName").val(res.data.ownerName);
                $("#ownerPhone").val(res.data.phoneNo);
                $("#ownerNumber").val(res.data.plateNo);
                if (res.data.idNo) {
                    $("#IDNumber").val(res.data.idNo);
                }else{
                    $("#IDNumber").val("");
                }
                if (res.data.registrationDate) {
                    $("#registrationDate").val(res.data.registrationDate);
                } else {
                    $("#registrationDate").val("");
                }
                if (res.data.purchasePrice) {
                    $("#purchasePrice").val(res.data.purchasePrice);
                }else {
                    $("#purchasePrice").val("");
                }
                if (res.data.insurer) {
                    $("#insuranceCompany").val(res.data.insurer);
                }else{
                    $("#insuranceCompany").val("");
                }
                if (res.data.compulsoryInsFee) {
                    $("#accidentsInsurance").val(res.data.compulsoryInsFee);
                }else{
                    $("#accidentsInsurance").val("");
                }
                if (res.data.commercialInsFee) {
                    $("#commercialInsurance").val(res.data.commercialInsFee);
                }else{
                    $("#commercialInsurance").val("");
                }
                if (res.data.renewalDate) {
                    $("#renewalDate").val(res.data.renewalDate);
                } else {
                    $("#renewalDate").val("");
                }
                if (res.data.introducer) {
                    $("#introducer").val(res.data.introducer);
                }else{
                    $("#introducer").val("");
                }
                if (res.data.introducerPhone) {
                    $("#introducerPhone").val(res.data.introducerPhone);
                }else{
                    $("#introducerPhone").val("");
                }
                if (res.data.introducerWechat) {
                    $("#introducerWechart").val(res.data.introducerWechat);
                }else{
                    $("#introducerWechart").val("");
                }
                if (res.data.provinceId) {
                    $("#province").val(res.data.provinceId);
                    provinceValue = res.data.provinceId;
                }
                if (res.data.cityId) {
                    cityValue = res.data.cityId;
                }
                if (res.data.wechatId) {
                    $("#ownerWechat").val(res.data.wechatId);
                }else{
                    $("#ownerWechat").val("");
                }
                if (res.data.vinNo) {
                    $("#carNumber").val(res.data.vinNo);
                }else{
                    $("#carNumber").val("");
                }
                var data1 = {};
                if (provinceValue != '') {
                    $.ajax({
                        type: 'POST',
                        contentType: 'application/json;charset=UTF-8',
                        dataType: 'json',
                        url: "https://mdev.zuihuibi.cn/api/metadata/provCityQry",
                        data: JSON.stringify(data1),
                        beforeSend: function(request) {
                            request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
                        },
                        success: function (d) {
                            var list = d.data.provinces;
                            for (var i = 0; i < list.length; i++) {
                                if (list[i].provinceId == provinceValue) {
                                    var cityList = list[i].citys;
                                    $("#city").empty();
                                    for (var j = 0; j < cityList.length; j++) {
                                        $("#city").append('<option value="' + cityList[j].cityId + '">' + cityList[j].cityName + '</option>');
                                    }
                                }
                            }
                            $("#city").val(cityValue);
                        }
                    })
                } else {
                    $("#province").val("");
                    $("#city").empty();
                    $("#city").append('<option value="">请选择城市</option>');
                }
            }
        }
    })
})
// 更新
$("#btnUpDate").click(function () {
    // 验证必填项
    var name = $("#ownerName").val();
    var ownerPhone = $("#ownerPhone").val();
    var ownerNumber = $("#ownerNumber").val();



    var IDNumber = $("#IDNumber").val();
    var insuranceCompany = $("#insuranceCompany").val();
    var introducer = $("#introducer").val();
    var introducerPhone = $("#introducerPhone").val();
    var provinceId = $('#province option:selected').val();
    var registrationProvince = '';
    if (provinceId != '') {
        registrationProvince = $('#province option:selected').text();
    }
    var registrationCity = "";
    var cityId = $('#city option:selected').val();
    if (cityId != '') {
        registrationCity = $('#city option:selected').text();
    }
    var registrationDate = $("#registrationDate").val();
    var purchasePrice = $("#purchasePrice").val();
    var insurer = $("#insuranceCompany").val();
    var compulsoryInsFee = $("#accidentsInsurance").val();
    var commercialInsFee = $("#commercialInsurance").val();
    var renewalDate = $("#renewalDate").val();
    var introducer = $("#introducer").val();
    var introducerPhone = $("#introducerPhone").val();
    var introducerWechat = $("#introducerWechart").val();
    var vehicleId = $("#vehicleId").val();
    var carNumber = $("#carNumber").val();
    var ownerWechat = $("#ownerWechat").val();


    if (name != '') {
        // 验证姓名是否合法
        if (!namereg.test(name)) {
            layer.msg("请正确输入您的姓名！");
            return;
        }
    } else {
        layer.msg("请输入您的姓名！");
        return;
    }
    if (ownerPhone != '') {
        if (!phonereg.test(ownerPhone)) {
            layer.msg("请正确输入您的手机号码！");
            return;
        }
    } else {
        layer.msg("请输入您的手机号码！");
        return;
    }
    // 身份证号码验证
    if (IDNumber != "") {
        if (!IdCodeValid(IDNumber).pass) {
            layer.msg("请正确输入您的身份证号码！");
            return;
        }
    }
    if (ownerNumber != '') {
        if (!expressreg.test(ownerNumber)) {
            layer.msg("请正确输入您的车牌号！");
            return;
        }
    } else {
        layer.msg("请输入您的车牌号！");
        return;
    }

    if (carNumber != '') {
        if (!carReg.test(carNumber)) {
            layer.msg("请正确输入您的VIN！");
            return;
        }
    }

    if (insuranceCompany != '') {
        if (!namereg.test(insuranceCompany)) {
            layer.msg("请正确输入您的车辆目前受保险公司！");
            return;
        }
    }
    if (introducer != '') {
        if (!namereg.test(introducer)) {
            layer.msg("请正确输入推荐人姓名！");
            return;
        }
    }
    if (introducerPhone != '') {
        if (!checkTel(introducerPhone)) {
            layer.msg("请正确输入推荐人电话！");
            return;
        }
    }
    // 提交成功设置不可编辑
    var upDate = {
        ownerName: name,
        phoneNo: ownerPhone,
        idNo: IDNumber,
        plateNo: ownerNumber,
        registrationProvince: registrationProvince,
        provinceId: provinceId,
        registrationCity: registrationCity,
        cityId: cityId,
        registrationDate: registrationDate,
        purchasePrice: delcommafy(purchasePrice),
        insurer: insurer,
        compulsoryInsFee: delcommafy(compulsoryInsFee),
        commercialInsFee: delcommafy(commercialInsFee),
        renewalDate: renewalDate,
        introducer: introducer,
        introducerPhone: introducerPhone,
        introducerWechat: introducerWechat,
        vehicleId: vehicleId,
        wechatId: ownerWechat,
        vinNo: carNumber
    };
    // 查询入参
    var searchData = {
        plateNo: ownerNumber,
        ownerName: name,
        phoneNo: ownerPhone,
        idNo: IDNumber,
        registrationProvince: registrationProvince
    };
    $.ajax({
        type: 'POST',
        contentType: 'application/json;charset=UTF-8',
        dataType: 'json',
        url: "https://mdev.zuihuibi.cn/api/vehicleUpdate",
        data: JSON.stringify(upDate),
        beforeSend: function(request) {
            request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
        },
        success: function (d) {
            if (d.success) {
                // 存入隐藏标签
                $("#personName").val(name);
                $("#personPhone").val(ownerPhone);
                $("#personCar").val(ownerNumber);

                layer.msg("更新成功,我们的保险经纪人会尽快和你取得联系!");
                $("input[type=text]").attr('disabled', true);
                $("input[type=number]").attr('disabled', true);
                $("#province").attr("disabled", true);
                $("#city").attr("disabled", true);
                $("#btnSave").hide();
                $(".btnSubmit .btnEdit").show();
                $(".wrap .btnConfrim").hide();
                var cityValue = '';
                var provinceValue = '';
                $.ajax({
                    type: 'POST',
                    contentType: 'application/json;charset=UTF-8',
                    dataType: 'json',
                    url: "https://mdev.zuihuibi.cn/api/vehicleQuery",
                    data: JSON.stringify(searchData),
                    beforeSend: function(request) {
                        request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
                    },
                    success: function (res) {
                        if (res.success) {
                            $("#ownerName").val(res.data.ownerName);
                            $("#ownerPhone").val(res.data.phoneNo);
                            $("#ownerNumber").val(res.data.plateNo);
                            $("#vehicleId").val(res.data.vehicleId);
                            if (res.data.idNo) {
                                $("#IDNumber").val(res.data.idNo);
                            }
                            if (res.data.registrationDate) {
                                $("#registrationDate").val(res.data.registrationDate);
                            }
                            if (res.data.purchasePrice) {
                                $("#purchasePrice").val(res.data.purchasePrice);
                            }
                            if (res.data.insurer) {
                                $("#insuranceCompany").val(res.data.insurer);
                            }
                            if (res.data.compulsoryInsFee) {
                                $("#accidentsInsurance").val(res.data.compulsoryInsFee);
                            }
                            if (res.data.commercialInsFee) {
                                $("#commercialInsurance").val(res.data.commercialInsFee);
                            }
                            if (res.data.renewalDate) {
                                $("#renewalDate").val(res.data.renewalDate);
                            }
                            if (res.data.introducer) {
                                $("#introducer").val(res.data.introducer);
                            }
                            if (res.data.introducerPhone) {
                                $("#introducerPhone").val(res.data.introducerPhone);
                            }
                            if (res.data.introducerWechat) {
                                $("#introducerWechart").val(res.data.introducerWechat);
                            }
                            if (res.data.provinceId) {
                                $("#province").val(res.data.provinceId);
                                provinceValue = res.data.provinceId;
                            }
                            if (res.data.cityId) {
                                cityValue = res.data.cityId;
                            }
                            if (res.data.wechatId) {
                                $("#ownerWechat").val(res.data.wechatId);
                            }
                            if (res.data.vinNo) {
                                $("#carNumber").val(res.data.vinNo);
                            }
                            var data1 = {};
                            if (provinceValue != '') {
                                $.ajax({
                                    type: 'POST',
                                    contentType: 'application/json;charset=UTF-8',
                                    dataType: 'json',
                                    url: "https://mdev.zuihuibi.cn/api/metadata/provCityQry",
                                    data: JSON.stringify(data1),
                                    beforeSend: function(request) {
                                        request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
                                    },
                                    success: function (d) {
                                        var list = d.data.provinces;
                                        for (var i = 0; i < list.length; i++) {
                                            if (list[i].provinceId == provinceValue) {
                                                var cityList = list[i].citys;
                                                $("#city").empty();
                                                for (var j = 0; j < cityList.length; j++) {
                                                    $("#city").append('<option value="' + cityList[j].cityId + '">' + cityList[j].cityName + '</option>');
                                                }
                                            }
                                        }
                                        $("#city").val(cityValue);
                                    }
                                })
                            }
                        } else {
                            layer.msg(res.data.message);
                        }
                    }
                })
            } else {
                layer.msg("更新失败！");
            }
        }
    })
})
$("#purchasePrice").blur(function () {
    var purchasePrice = $(this).val();
    $("#purchasePrice").val(formatCurrency(purchasePrice));
})
$("#accidentsInsurance").blur(function () {
    var accidentsInsurance = $(this).val();
    $("#accidentsInsurance").val(formatCurrency(accidentsInsurance));
})
$("#commercialInsurance").blur(function () {
    var commercialInsurance = $(this).val();
    $("#commercialInsurance").val(formatCurrency(commercialInsurance));
})
// 限制只能输入数字和小数点
function clearNoNum(obj) {
    obj.value = obj.value.replace(/[^\d.]/g, "");  //清除“数字”和“.”以外的字符

    obj.value = obj.value.replace(/^\./g, "");  //验证第一个字符是数字而不是.

    obj.value = obj.value.replace(/\.{2,}/g, "."); //只保留第一个. 清除多余的.

    obj.value = obj.value.replace(".", "$#$").replace(/\./g, "").replace("$#$", ".");

}
function formatCurrency(num) {
    if (num != '') {
        num = num.toString().replace(/\$|\,/g, '');
        if (isNaN(num))
            num = "0";
        var sign = (num == (num = Math.abs(num)));
        num = Math.floor(num * 100 + 0.50000000001);
        var cents = num % 100;
        num = Math.floor(num / 100).toString();
        if (cents < 10)
            cents = "0" + cents;
        for (var i = 0; i < Math.floor((num.length - (1 + i)) / 3); i++)
            num = num.substring(0, num.length - (4 * i + 3)) + ',' +
                num.substring(num.length - (4 * i + 3));
        return (((sign) ? '' : '-') + num + '.' + cents);
    }
}
// 去除千分位
function delcommafy(num) {
    if ((num + "").trim() == "") {
        return "";
    }
    num = num.replace(/,/gi, '');
    return num;
}
// 省份城市查询
var data1 = {};
$.ajax({
    type: 'POST',
    contentType: 'application/json;charset=UTF-8',
    dataType: 'json',
    url: "https://mdev.zuihuibi.cn/api/metadata/provCityQry",
    data: JSON.stringify(data1),
    beforeSend: function(request) {
        request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
    },
    success: function (d) {
        var list = d.data.provinces;
        $("#province").empty();
        for (var i = 0; i < list.length; i++) {
            if (i == 0) {
                $("#province").append('<option value="">请选择省份</option>>')
            }
            $("#province").append('<option value="' + list[i].provinceId + '">' + list[i].provinceName + '</option>>');
        }
    }
})
// 根据省份选择城市
$("#province").change(function () {
    var provinceId = $(this).val();
    if (provinceId != '') {
        $.ajax({
            type: 'POST',
            contentType: 'application/json;charset=UTF-8',
            dataType: 'json',
            url: "https://mdev.zuihuibi.cn/api/metadata/provCityQry",
            data: JSON.stringify(data1),
            beforeSend: function(request) {
                request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
            },
            success: function (d) {
                var list = d.data.provinces;
                for (var i = 0; i < list.length; i++) {
                    if (list[i].provinceId == provinceId) {
                        var cityList = list[i].citys;
                        $("#city").empty();
                        for (var j = 0; j < cityList.length; j++) {
                            $("#city").append('<option value="' + cityList[j].cityId + '">' + cityList[j].cityName + '</option>');
                        }
                    }
                }
            }
        })
    } else {
        $("#city").empty();
        $("#city").append('<option value="">请选择城市</option>');
    }
})

function checkTel(tel) {
    var mobile = /^1[3|5|8]\d{9}$/, phone = /^0\d{2,3}-?\d{7,8}$/;
    return mobile.test(tel) || phone.test(tel);
}
// 将毫秒数转化为日期
function getMyDate(str) {
    var oDate = new Date(str),
        oYear = oDate.getFullYear(),
        oMonth = oDate.getMonth() + 1,
        oDay = oDate.getDate(),
        oTime = oYear + '-' + getzf(oMonth) + '-' + getzf(oDay);//最后拼接时间
    return oTime;
};
function getzf(num) {
    if (parseInt(num) < 10) {
        num = '0' + num;
    }
    return num;
}
// 获取当前日期
function getNowFormatDate() {
    var date = new Date();
    var seperator1 = "-";
    var year = date.getFullYear();
    var month = date.getMonth() + 1;
    var strDate = date.getDate();
    if (month >= 1 && month <= 9) {
        month = "0" + month;
    }
    if (strDate >= 0 && strDate <= 9) {
        strDate = "0" + strDate;
    }
    var currentdate = year + seperator1 + month + seperator1 + strDate;
    return currentdate;
}
// 获取token
function getToken() {
    var objParam = {
        ticket: 'car'
    };
    $.ajax({
        type: "post",
        contentType: 'application/json;charset=UTF-8',
        url: "https://mdev.zuihuibi.cn/api/authorize/obtainToken",
        dataType: "json",
        async: false,
        data: JSON.stringify(objParam),
        beforeSend: function(request) {
            request.setRequestHeader("X-Authorization", localStorage.getItem('token'));
        },
        success: function (res) {
            console.log(res);
            localStorage.setItem('token', res.data.token);
        },
        error: function (xhr, status, error) {

        }
    })
}



function IdCodeValid(code) {
    // 身份证号合法性验证
    // 支持15位和18位身份证号
    // 支持地址编码、出生日期、校验位验证
    var city = {
        11: '北京',
        12: '天津',
        13: '河北',
        14: '山西',
        15: '内蒙古',
        21: '辽宁',
        22: '吉林',
        23: '黑龙江 ',
        31: '上海',
        32: '江苏',
        33: '浙江',
        34: '安徽',
        35: '福建',
        36: '江西',
        37: '山东',
        41: '河南',
        42: '湖北 ',
        43: '湖南',
        44: '广东',
        45: '广西',
        46: '海南',
        50: '重庆',
        51: '四川',
        52: '贵州',
        53: '云南',
        54: '西藏 ',
        61: '陕西',
        62: '甘肃',
        63: '青海',
        64: '宁夏',
        65: '新疆',
        71: '台湾',
        81: '香港',
        82: '澳门',
        91: '国外 '
    };
    var row = {
        'pass': true,
        'msg': '验证成功'
    };
    // 出生年月日校验   前正则限制起始年份为1900;
    var year = code.substr(6, 4);// 身份证年
    var month = code.substr(10, 2);// 身份证月
    var date = code.substr(12, 2);// 身份证日
    var time = Date.parse(month + '-' + date + '-' + year);// 身份证日期时间戳date
    var now_time = Date.parse(new Date().toDateString());
    var dates = (new Date(year, month, 0)).getDate();// 身份证当月天数
    if (!code || !/^\d{6}(19|20)?\d{2}(0[1-9]|1[012])(0[1-9]|[12]\d|3[01])\d{3}(\d|[xX])$/.test(code)) {
        row = {
            'pass': false,
            'msg': '身份证号格式错误'
        };
    } else if (!city[code.substr(0, 2)]) {
        row = {
            'pass': false,
            'msg': '身份证号地址编码错误'
        };
    } else if (time > now_time || date > dates) {
        row = {
            'pass': false,
            'msg': '出生日期不合规'
        }
    } else {
        // 18位身份证需要验证最后一位校验位
        if (code.length == 18) {
            code = code.split('');
            // ∑(ai×Wi)(mod 11)
            // 加权因子
            var factor = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
            // 校验位
            var parity = [1, 0, 'X', 9, 8, 7, 6, 5, 4, 3, 2];
            var sum = 0;
            var ai = 0;
            var wi = 0;
            for (var i = 0; i < 17; i++) {
                ai = code[i];
                wi = factor[i];
                sum += ai * wi;
            }
            if (parity[sum % 11] != code[17].toUpperCase()) {
                row = {
                    'pass': false,
                    'msg': '身份证号校验位错误'
                };
            }
        }
    }
    return row;
}