import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core'

@Component({
  selector: 'app-page11',
  templateUrl: './page11.component.html',
  styleUrls: ['./page11.component.css']
})
export class Page11Component implements OnInit {
  @Input() curPageData: Array<any>
  @Output() getAllAnswer = new EventEmitter<any>()
  allOption: object
  constructor() {}

  ngOnInit() {
    this.allOption = {}
    console.log(this.curPageData)
  }
  getAnswer(options) {
    console.log(options)
    if (!this.allOption[options['optionId']]) {
      this.allOption[options['optionId']] = {}
    }
    this.allOption[options['optionId']] = {
      selected: !this.allOption[options['optionId']]['selected'],
      options
    }
    const options_ret = Object.keys(this.allOption)
      .filter(item => {
        return this.allOption[item]['selected']
      })
      .map(questionId => {
        return {
          options: this.allOption[questionId]
        }
      })
    const ret = {
      pageId: this.curPageData['pageId'],
      questions: [
        {
          questionId: this.curPageData['questions'][0].questionId,
          options: options_ret
        }
      ]
    }
    this.getAllAnswer.emit(ret)
  }
}
