import { Injectable } from '@angular/core';
import {environment} from './../environments/environment';
import {HttpClient, HttpHeaders} from '@angular/common/http';
import {LocalStorage} from './local.storage';
@Injectable({
  providedIn: 'root'
})
export class CommonService {
  private USER_API_URL = '';
  private httpOptions;
  questionList:Array<any>;
  constructor(private http: HttpClient,
    private ls: LocalStorage
    ) { 
  this.USER_API_URL = environment.apiUrl;
  this.httpOptions = {
    headers: new HttpHeaders({
      'Content-Type': 'application/json',
      'X-Authorization': ''
    })
  };
  
 }
  async surveyInfo() {
  const url = this.USER_API_URL + '/survey/surveyInfo';
  const res = await this.obtainToken();
  this.httpOptions.headers = this.httpOptions.headers.set('X-Authorization', res['data']['token']);
  return this.http
    .post(url, JSON.stringify({}),this.httpOptions).toPromise()
  }

  async getAllInfo(){
    const res = await this.surveyInfo()
    if(res['success']){
      this.questionList =  res['data']['survey'].pages
    }
  }

  /**
   * 获取TOKEN
   */
  obtainToken() {
    const url = this.USER_API_URL + '/authorize/obtainToken';
    const ticketObj = {
      ticket: 'questionnair'
    };
    return this.http.post(url, JSON.stringify(ticketObj), this.httpOptions).toPromise();
  }
}
