import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'mobileNoFormat'
})
export class MobileNoFormatPipe implements PipeTransform {

  transform(value: any, args?: any): any {
    let str = value.toString().replace(/ /g, '');
    const len = str.length;
    switch (true) {
      case len > 11:
        str = str.substr(0, 3) + ' ' + str.substr(3, 4) + ' ' + str.substr(7, 4);
        value = str;
        break;
      case len > 7:
        str = str.substr(0, 3) + ' ' + str.substr(3, 4) + ' ' + str.substr(7);
        value = str;
        break;
      case len > 3:
        str = str.substr(0, 3) + ' ' + str.substr(3);
        value = str;
        break;
      default:
        value = str;
    }
    return value;
  }

}
