import {Component, OnInit} from '@angular/core';
import {CommonService} from '../common.service';
import {ActivatedRoute, Router} from "@angular/router";

@Component({
  selector: 'app-social-security',
  templateUrl: './social-security.component.html',
  styleUrls: ['./social-security.component.css']
})
export class SocialSecurityComponent implements OnInit {
  curPageData: Array<any>;
  hasMate: boolean;
  // 家庭结构
  type: any;
  nextBtn: boolean;
  pageAnswers: any;

  constructor(private commonService: CommonService,
              private router: Router,
              private route: ActivatedRoute) {
    /**
     * 1:单身贵族
     * 2：二人世界
     * 3：独立带娃
     * 4：多口之家
     * @type {any}
     */
    this.type = this.route.snapshot.queryParams['type'];
    this.pageAnswers = {
      pageId: '',
      questions: [],
    };
  }

  ngOnInit() {
    this.surveyInfo();
    // 判断家庭决定是否显示配偶
    if (this.type == 2 || this.type == 4) {
      this.hasMate = true;
    } else {
      this.hasMate = false;
    }
    this.nextBtn = false;
  }

  surveyInfo() {
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['8'];
        this.pageAnswers.pageId = this.curPageData['pageId'];
        // console.log(this.curPageData)
      }
    })
  }

  selectedSocial(question, option) {
    option.selected = !option.selected;
    const questions = {
      questionId: question.questionId,
      questionName: question.questionName,
      options: []
    };
    if (question['options'].length > 0) {
      for (let j = 0; j < question['options'].length; j++) {
        if (question['options'][j].optionId == option.optionId) {
          question['options'][j].selected = true;
        } else {
          question['options'][j].selected = false;
        }
        // 拿到所有selected为true的选项
        if (question['options'][j]['selected']) {
          questions.options.push(question['options'][j]);
        }
      }
    }
    for (let i = 0; i < this.pageAnswers.questions.length; i++) {
      if (this.pageAnswers.questions[i].questionId == question.questionId) {
        const index = this.pageAnswers.questions.indexOf(this.pageAnswers.questions[i]);
        this.pageAnswers.questions.splice(index, 1);
      }
    }
    this.pageAnswers.questions.push(questions);
    // console.log(this.pageAnswers)
    this.commonService.addAnswer(this.pageAnswers);
    // 判断页面需要几个问题
    if (this.type == 2 || this.type == 4) {
      if (this.curPageData['questions'].length == this.pageAnswers['questions'].length) {
        this.nextBtn = true;
      } else {
        this.nextBtn = false;
      }
    } else {
      if (this.pageAnswers['questions'].length > 0) {
        this.nextBtn = true;
      } else {
        this.nextBtn = false;
      }
    }
  }

  next() {
    if (this.nextBtn == true) {
      this.router.navigate(['/transit2'], {queryParams: {type: this.type}})
    } else {
      return;
    }
  }

  //  上一步
  before() {
    this.commonService.before();
  }
}
