import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
@Component({
  selector: 'ydlife-score-details',
  templateUrl: './score-details.component.html',
  styleUrls: ['./score-details.component.scss']
})
export class ScoreDetailsComponent implements OnInit {
  salesScoreDetails: Array<any>;
  selectedTime: string;
  constructor(private myService: MyService) { }
  ngOnInit() {
    this.selectedTime = 'D';
    this.salesScoreDetailQuery('D');
  }

  //销售活动量详情D-天 W-周 M-月
  salesScoreDetailQuery(time) {
    this.selectedTime = time;
    const practitionerId = JSON.parse(localStorage.getItem('ydgiCustomerInfo'))['practitionerId'];
    this.myService.salesScoreDetailQuery({ practitionerId: practitionerId, time: this.selectedTime }).subscribe((res) => {
      if (res['success']) {
        this.salesScoreDetails = res['data']['salesScoreDetails'];
      }
    })
  }

}
