import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { environment } from '../../../environments/environment';
import { LifeCommonService } from '../../common/life-common.service';
import { MyService } from '../my.service';


declare var QRCode: any;
import * as uuid from 'uuid';

@Component({
  selector: 'ydlife-mk-material-detail',
  templateUrl: './mk-material-detail.component.html',
  styleUrls: ['./mk-material-detail.component.scss']
})
export class MkMaterialDetailComponent implements OnInit {
  @ViewChild('canvas') canvas: ElementRef<any>;
  materialItemId: string;
  // 1是指itemId 是productID 2是指planid
  materialItemType: string;
  // 海报图
  productPosterPath: string;
  ydgiCustomerInfo: any;
  shareInfo: any;
  // 自定义内容部分高度
  contentHeight: number = 90;
  // 二维码宽度
  qrcodeWidth: number = 70;
  qrcodeBgWidth: number = 80;
  qrcodePadding = 5;
  rightWidth = 5;
  bottomHeight = 5;
  posterType: number;
  isMobileShow: number;
  isNameShow: number;

  constructor(private activateRoute: ActivatedRoute,
    private lifeCommonService: LifeCommonService,
    private myService: MyService) {
  }

  ngOnInit() {
    this.materialItemId = this.activateRoute.snapshot.paramMap.get('itemId');
    this.materialItemType = this.activateRoute.snapshot.queryParams['itemType'];
    this.ydgiCustomerInfo = localStorage.getItem('ydgiCustomerInfo') ? JSON.parse(localStorage.getItem('ydgiCustomerInfo')) : null;
    this.posterType = this.activateRoute.snapshot.queryParams['posterType'];
    this.posterQuery(this.posterType, this.materialItemType);
  }

  async canvasPic() {
    const qrcodeUrl = await this.qrcode() + '';
    const canvas = this.canvas.nativeElement as HTMLCanvasElement;
    const ctx = canvas.getContext('2d');
    const ratio = this.getPixelRatio(ctx);
    const W = document.body.clientWidth;
    // const H = document.body.clientHeight;
    const H = W * (734 / 413);
    canvas.width = W * ratio;
    canvas.height = H * ratio;
    canvas.style.width = W + 'px';
    canvas.style.height = H + 'px';
    const img = new Image();
    img.setAttribute('crossOrigin', 'anonymous');
    // 画圆形头像
    const avatarurlWidth = 50 * ratio;    // 绘制的头像宽度
    const avatarurlHeigth = 50 * ratio;  // 绘制的头像高度
    const avatarurlX = 20 * ratio;  // 绘制的头像在画布上的位置
    const avatarurlY = this.canvas.nativeElement.height - (this.contentHeight + 50) / 2 * ratio;  // 绘制的头像在画布上的位置
    const avatarImg = new Image();
    avatarImg.setAttribute('crossOrigin', 'anonymous');
    if (this.ydgiCustomerInfo.practitionerBasicInfo.headImagePath) {
      avatarImg.src = this.ydgiCustomerInfo.practitionerBasicInfo.headImagePath + '?v=' + new Date().getTime();
    } else {
      avatarImg.src = `${environment.DOMAINNAME}/assets/img/meng.png?v=${new Date().getTime()}`;
    }
    // 这里的第一张图片就是可以是你们的海报 这里注意绘制的顺序 我们要手动控制
    img.src = this.productPosterPath;
    img.onload = () => {
      // 加载海报图
      // ctx.drawImage(img, 0, 0, this.canvas.nativeElement.width, this.canvas.nativeElement.width * (734 / 413));
      ctx.drawImage(img, 0, 0, this.canvas.nativeElement.width, this.canvas.nativeElement.height);
      ctx.save();
      ctx.fillStyle = 'rgba(0,0,0,0.15)';
      ctx.fillRect(0, this.canvas.nativeElement.height - this.contentHeight * ratio, this.canvas.nativeElement.width * ratio, this.contentHeight * ratio);
      ctx.beginPath(); // 开始绘制
      // 先画个圆  前两个参数确定了圆心 （x,y） 坐标  第三个参数是圆的半径  四参数是绘图方向  默认是false，即顺时针
      ctx.arc(avatarurlWidth / 2 + avatarurlX, avatarurlHeigth / 2 + avatarurlY, avatarurlWidth / 2, 0, Math.PI * 2, false);
      ctx.clip(); // 画好了圆 剪切  原始画布中剪切任意形状和尺寸。一旦剪切了某个区域，则所有之后的绘图都会被限制在被剪切的区域内 这也是我们要save上下文的原因
      ctx.drawImage(avatarImg, avatarurlX, avatarurlY, avatarurlWidth, avatarurlHeigth); // 推进去图片，必须是https图片
      ctx.restore(); // 恢复之前保存的绘图上下文 恢复之前保存的绘图上下午即状态 还可以继续绘制
      ctx.save();
      // 这里的image只能在onload里面绘制 在外面就会被覆盖了 因为优先加载完毕就会优先绘制 然后就被之后绘制的海报背景遮挡了
      const shareQr = new Image();
      // 设置base64编码格式值

      if (this.materialItemType == '5') {
        shareQr.src = `assets/images/online.jpg`;
      } else {
        shareQr.src = qrcodeUrl;
      }
      shareQr.onload = () => {
        //二维码位置
        const qrcodeBgX = document.body.clientWidth - (this.rightWidth + this.qrcodeBgWidth + 20);
        const qrcodeBgY = H - (this.bottomHeight + this.qrcodeBgWidth);
        //二维码底边padding
        const qrcodeX = qrcodeBgX + this.qrcodePadding;
        const qrcodeY = qrcodeBgY + this.qrcodePadding;
        ctx.fillStyle = '#fff';
        ctx.fillRect(qrcodeBgX, qrcodeBgY, this.qrcodeBgWidth, this.qrcodeBgWidth);
        ctx.save();
        // // 绘制图像  就是绘制二维码到我们自己写的canvas中去
        ctx.drawImage(shareQr, qrcodeX, qrcodeY, this.qrcodeWidth, this.qrcodeWidth);
        document.querySelector('#bannerImg').setAttribute('src', canvas.toDataURL('image/png', 1));
        this.canvas.nativeElement.style.display = 'none';
      };
      // 绘制字体
      ctx.fillStyle = '#fff';
      ctx.font = `${12 * ratio}px 微软雅黑`;

      if (this.isNameShow == 1) {
        ctx.fillText(`${this.ydgiCustomerInfo.practitionerBasicInfo.name}`, 75 * ratio, avatarurlY + 15 * ratio); // Y指的是文字底部的位置
      }
      ctx.fillText(`银盾保险经纪`, 75 * ratio, avatarurlY + 30 * ratio); // Y指的是文字底部的位置
      if (this.isMobileShow == 1) {
        ctx.fillText(`${this.ydgiCustomerInfo.mobileNo}`, 75 * ratio, avatarurlY + 45 * ratio);
      }
      ctx.scale(ratio, ratio);
    };
  }

  // 获取像素比
  getPixelRatio(context) {
    const backingStore = context.backingStorePixelRatio ||
      context.webkitBackingStorePixelRatio ||
      context.mozBackingStorePixelRatio ||
      context.msBackingStorePixelRatio ||
      context.oBackingStorePixelRatio ||
      context.backingStorePixelRatio || 1;
    return (window.devicePixelRatio || 1) / backingStore;
  }

  shareCallBack() {
    this.myService.shareCallBack(this.shareInfo).subscribe(res => {
      if (res['success']) {
        setTimeout(() => {
          this.canvasPic();
        }, 500);
      } else {

      }
    });
  }

  download() {
    const a = document.createElement('a');
    // 设置地址
    const canvas = document.querySelector('#qrcode canvas') as HTMLCanvasElement;
    a.href = canvas.toDataURL('image/png', 1);
    // 设置下载名称
    a.download = '银盾保险经纪';
    // 触发点击事件
    a.click();
  }

  qrcode() {
    return new Promise((resolve, reject) => {
      const qr = document.querySelector('#qrcode');
      // 对二维码进行初始化
      const qrCode = new QRCode(qr, {
        // 二维码内容
        text: `${this.shareInfo.url}`,
        // 二维码宽度
        width: 100,
        // 二维码高度
        height: 100,
        // 二维码前景色
        colorDark: '#000',
        // 二维码背景色
        colorLight: '#fff',
        /*!
         容错级别，可设置为：
         QRCode.CorrectLevel.L
         QRCode.CorrectLevel.M
         QRCode.CorrectLevel.Q
         QRCode.CorrectLevel.H
         */
        correctLevel: QRCode.CorrectLevel.H,
        // 二维码中心图片
        iconSrc: `./assets/images/icons/yd.jpg`,
        // 二维码中心图片边框弧度
        iconRadius: 6,
        // 二维码中心图片边框宽度
        iconBorderWidth: 5,
        // 二维码中心图片边框颜色
        iconBorderColor: '#fff',
      });
      // 我们的qrcode生成二维码之后也会有一个canvas对象我们获取到这个元素
      // 这里的image只能在onload里面绘制 在外面就会被覆盖了 因为优先加载完毕就会优先绘制 然后就被之后绘制的海报背景遮挡了
      setTimeout(() => {
        const newCanvas = document.querySelector('#qrcode canvas') as HTMLCanvasElement;
        const qrcodeUrl = newCanvas.toDataURL('image/png', 1);
        resolve(qrcodeUrl);
      }, 100)
    });
  }

  //  获取大图
  posterQuery(itemId, itemType) {
    this.myService.posterQuery({
      id: this.posterType,
      practitionerId: JSON.parse(localStorage.getItem('ydgiCustomerInfo'))['practitionerId'],
      paginationInfo: {
        noLimitFlag: 'CONFIRM'
      }
    }).subscribe(res => {
      if (res['success']) {
        this.isMobileShow = res['data']['isMobileShow'];
        this.isNameShow = res['data']['isNameShow'];
        const posterInfos = res['data']['posterInfos'];
        const posterInfo = posterInfos.filter(item => item.id == itemId && item.itemType == itemType).pop();
        this.productPosterPath = posterInfo.productPosterPath + '?v=' + new Date().getTime();
        // 分享信息
        const shareCodeUuid = uuid.v4();
        this.shareInfo = {
          ...this.lifeCommonService.generateShareCode(),
          shareCode: shareCodeUuid,
          customerId: this.ydgiCustomerInfo.customerId,
          productId: this.materialItemId,
          url: `${environment.DOMAINNAME}/life/${this.materialItemId}?shareCode=${shareCodeUuid}`
        };
        if (itemType == '2') {
          this.shareInfo.productId = null;
          this.shareInfo.planId = this.materialItemId;
        }
        // 0是有plan，1是无plan
        if (posterInfo.isPlan == '0') {
          if (posterInfo.productCategoryId == '2') {
            this.shareInfo.url = `${environment.DOMAINNAME}/hProductDetail/${this.materialItemId}?shareCode=${shareCodeUuid}&type=7`;
          } else if (posterInfo.productCategoryId == '5') {
            this.shareInfo.url = `${environment.DOMAINNAME}/hProductDetail/${this.materialItemId}?shareCode=${shareCodeUuid}&type=9`;
          }
        }

        // 发送请求保存分享码
        this.shareCallBack();
      }
    });
  }
}
