/// <reference types="uni-app" />
import Painter from "../painter";
export declare type CompatableContext = CanvasContext | CanvasRenderingContext2D;
export declare type PainterContext = Pick<CanvasContext, "arcTo" | "clip" | "draw" | "fillStyle" | "font" | "lineTo" | "restore" | "save" | "setFillStyle" | "setFontSize" | "setStrokeStyle" | "setTextAlign" | "setTextBaseline" | "strokeStyle" | "beginPath" | "closePath" | "moveTo" | "createLinearGradient" | "stroke" | "fill" | "strokeRect" | "fillRect" | "lineWidth" | "setLineDash" | "fillText" | "setTransform" | "scale" | "rotate" | "translate"> & {
    measureTextWidth(text: string, fontSize: number): number;
    drawImageWithSrc(imageResource: string, sx: number, sy: number, sWidth: number, sHeigt: number): Promise<void>;
    drawImageWithSrc(imageResource: string, sx: number, sy: number, sWidth: number, sHeigt: number, dx: number, dy: number, dWidth: number, dHeight: number): Promise<void>;
};
export declare function adaptContext(painter: Painter, ctx: CompatableContext): PainterContext;
