export default{
	// 获取url的参数
	getQueryString(name){
	    const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
	    const r = decodeURIComponent(window.location.search).substr(1).match(reg);
	    if (r != null) {
	      return r[2];
	    }
	    return null;
	},
	// 数字千分位
	numberConverter(value){
	  if (!value) return 0
	  // 获取整数部分
	  const intPart = Math.trunc(value)
	  // 整数部分处理，增加,
	  const intPartFormat = intPart.toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,')
	  // 预定义小数部分
	  let floatPart = ''
	  // 将数值截取为小数部分和整数部分
	  const valueArray = value.toString().split('.')
	  if (valueArray.length === 2) { // 有小数部分
	    floatPart = valueArray[1].toString() // 取得小数部分
	    return intPartFormat + '.' + floatPart
	  }
	  return intPartFormat + floatPart	
	},
	// 秒转换成时分秒
	secondsTransferPipe(value:number){
		   const h = Math.floor(value / 3600) > 0 ? Math.floor(value / 3600) : '00';
		  const m = Math.floor(value % 3600 / 60) > 0 ? Math.floor(value % 3600 / 60) : '00';
		  const s = Math.floor(value % 60) > 0 ? Math.floor(value % 60) : '00';
		  return h + ':' + m + ':' + s;
	},
	// 日期格式化
	dateFormat(val:number){
		if(val){
			const date = new Date(val);
			return date.getFullYear() + '-' + (date.getMonth() + 1) + '-' + date.getDate() + ' ' + date.getHours() + ':' + date.getMinutes() + ':' + date.getSeconds()
		}else {
			return val;
		}
	}
}