export default{
	// 获取url的参数
	getQueryString(name){
	    const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
	    const r = decodeURIComponent(window.location.search).substr(1).match(reg);
	    if (r != null) {
	      return r[2];
	    }
	    return null;
	},
	// 数字千分位
	numberConverter(value){
	  if (!value) return 0
	  // 获取整数部分
	  const intPart = Math.trunc(value)
	  // 整数部分处理，增加,
	  const intPartFormat = intPart.toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,')
	  // 预定义小数部分
	  let floatPart = ''
	  // 将数值截取为小数部分和整数部分
	  const valueArray = value.toString().split('.')
	  if (valueArray.length === 2) { // 有小数部分
	    floatPart = valueArray[1].toString() // 取得小数部分
	    return intPartFormat + '.' + floatPart
	  }
	  return intPartFormat + floatPart	
	},
	// 秒转换成时分秒
	secondsTransferPipe(value:number){
		   const h = Math.floor(value / 3600) > 0 ? (Math.floor(value / 3600) <= 9 ? '0' + Math.floor(value / 3600) : Math.floor(value / 3600)): '00';
		  const m = Math.floor(value % 3600 / 60) > 0 ? (Math.floor(value % 3600 / 60)<=9 ? '0'+Math.floor(value % 3600 / 60):Math.floor(value % 3600 / 60)) : '00';
		  const s = Math.floor(value % 60) > 0 ? (Math.floor(value % 60) <=9 ? '0'+Math.floor(value % 60) : Math.floor(value % 60)) : '00';
		  return h + ':' + m + ':' + s;
	},
	// 日期格式化
	dateFormat(val:number,format='yyyy-MM-dd hh:mm:ss'){
		console.log('val',val);
		if(val){
			const date = new Date(val);
			const year = date.getFullYear();
			const month = (date.getMonth() + 1) <10 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
			const day = date.getDate() < 10 ? '0' + date.getDate() :  date.getDate();
			const hours = date.getHours() < 10 ? '0' + date.getHours() : date.getHours();
			const minutes = date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes();
			const seconds = date.getSeconds() < 10 ? '0' + date.getSeconds() : date.getSeconds();
			
			if(format === 'yyyy-MM-dd'){
				return year + '-' + month + '-' + day
			}else if(format === 'yyyy-MM-dd hh:mm:ss'){
				return year + '-' + month + '-' + day + ' ' + hours + ':' + minutes+ ':' + seconds
			}
			
		}else {
			return val;
		}
	},
	// 年龄是否大于18
	 isAdult(birthDateString) {
		 if(!birthDateString) return 
	  // 拆分日期字符串
	  const parts = birthDateString.split('-');
	  if (parts.length !== 3) return false;
	
	  const year = parseInt(parts[0], 10);
	  const month = parseInt(parts[1], 10);
	  const day = parseInt(parts[2], 10);
	
	  // 检查年月日是否为有效数字
	  if (isNaN(year) || isNaN(month) || isNaN(day)) return false;
	
	  // 创建日期对象（月份从0开始）
	  const birthDate = new Date(year, month - 1, day);
	
	  // 验证日期有效性
	  if (
	    birthDate.getMonth() + 1 !== month ||
	    birthDate.getDate() !== day
	  ) {
	    return false;
	  }
	
	  const currentDate = new Date();
	
	  // 检查出生日期是否在当前日期之后
	  if (birthDate > currentDate) {
	    return false;
	  }
	
	  // 计算18年后的日期
	  const eighteenYearsLater = new Date(birthDate);
	  eighteenYearsLater.setFullYear(eighteenYearsLater.getFullYear() + 18);
	
	  // 判断是否已满18岁
	  return eighteenYearsLater <= currentDate;
	}
}