export default{
	// 获取url的参数
	getQueryString(name){
	    const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
	    const r = decodeURIComponent(window.location.search).substr(1).match(reg);
	    if (r != null) {
	      return r[2];
	    }
	    return null;
	},
	// 数字千分位
	numberConverter(value){
	  if (!value) return 0
	  // 获取整数部分
	  const intPart = Math.trunc(value)
	  // 整数部分处理，增加,
	  const intPartFormat = intPart.toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,')
	  // 预定义小数部分
	  let floatPart = ''
	  // 将数值截取为小数部分和整数部分
	  const valueArray = value.toString().split('.')
	  if (valueArray.length === 2) { // 有小数部分
	    floatPart = valueArray[1].toString() // 取得小数部分
	    return intPartFormat + '.' + floatPart
	  }
	  return intPartFormat + floatPart	
	},
	// 秒转换成时分秒
	secondsTransferPipe(value:number){
		   const h = Math.floor(value / 3600) > 0 ? Math.floor(value / 3600) : '00';
		  const m = Math.floor(value % 3600 / 60) > 0 ? Math.floor(value % 3600 / 60) : '00';
		  const s = Math.floor(value % 60) > 0 ? Math.floor(value % 60) : '00';
		  return h + ':' + m + ':' + s;
	},
	// 日期格式化
	dateFormat(val:number,format='yyyy-MM-dd hh:mm:ss'){
		if(val){
			const date = new Date(val);
			const year = date.getFullYear();
			const month = (date.getMonth() + 1) <10 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
			const day = date.getDate() < 10 ? '0' + date.getDate() :  date.getDate();
			const hours = date.getHours() < 10 ? '0' + date.getHours() : date.getHours();
			const minutes = date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes();
			const seconds = date.getSeconds() < 10 ? '0' + date.getSeconds() : date.getSeconds();
			
			if(format === 'yyyy-MM-dd'){
				return year + '-' + month + '-' + day
			}else if(format === 'yyyy-MM-dd hh:mm:ss'){
				return year + '-' + month + '-' + day + ' ' + hours + ':' + minutes+ ':' + seconds
			}
			
		}else {
			return val;
		}
	}
}