import request from "../util/request";
import {baseURL,apiURL,cffpURL} from "../environments/environment";

export default {
	//查看token是否已经失效
	checkToken(){
		const params = {
			token:uni.getStorageSync('uni-token'),
			ticket:'uni-app'
		}
		return request(`${baseURL}/api/authorize/checkToken`, "POST", params)
	},
	// 获取token
	obtainToken(){
		const params = {
			ticket:'uni-app'
		}
		return request(`${baseURL}/api/authorize/obtainToken`, "POST", params)
	},
	//获取验证码
	verificationCode(params){
		return request(`${baseURL}/api/verificationCode`, "POST", params)
	},
	//登录接口
	loginVerification(params){
		return request(`${cffpURL}/user/loginVerification`, "POST", params)
	},
	//注册接口
	register(params){
		return request(`${cffpURL}/user/register`, "POST", params)
	},
	//重置密码
	resetPassword(params){
		return request(`${cffpURL}/user/resetPassword`, "POST", params)
	},
	// 课程查询列表接口
	courseList(params){
		return request(`${cffpURL}/course/list`,"POST",params)
	},
	// 讲师信息查询
	lecturerQuery(params){
		return request(`${apiURL}/college/lecturerQuery`, "POST", params)
	},
	//账户信息获取
	queryAreaCenterInfo(params){
		return request(`${cffpURL}/areaCenter/queryAreaCenterInfo`, "POST", params)
	},
	//公告列表
	announcementQuery(params){
		return request(`${baseURL}/ydapi/market/announcementQuery`, "POST", params)
	},
	//消息列表
	querySystemMessage(params){
		return request(`${apiURL}/systemMessage/querySystemMessage`, "POST", params)
	},
	//清除站内消息
	oneKeyRead(params){
		return request(`${apiURL}/systemMessage/oneKeyRead`, "POST", params)
	},
	//消息详情&单个阅读
	querySystemMessageDetail(params){
		return request(`${apiURL}/systemMessage/querySystemMessageDetail`, "POST", params)
	},
	// 学习认证列表
	querySignupList(params){
		return request(`${cffpURL}/signup/querySignupList`, "POST", params)
	},
	// 个人认证列表
	userCertificateList(params){
		return request(`${cffpURL}/signup/userCertificateList`, "POST", params)
	},
	// 认证详情
	queryCertificateInfo(params){
		return request(`${cffpURL}/certificate/queryCertificateInfo`, "POST", params)
	},
	// 课程详情
	courseDetail(params){
		return request(`${cffpURL}/course/detail`, "POST", params)
	},
	// 相关课程黎贝澳查询
	relatedCoursesList(params){
		return request(`${cffpURL}/course/relatedCoursesList`, "POST", params)
	},
	//邀请加盟与申请加盟保存接口
	saveApplyInfo(params){
		return request(`${cffpURL}/partner/saveApplyInfo`, "POST", params)
	},
	//学习认证列表
	queryCertificateList(params){
		return request(`${cffpURL}/certificate/queryCertificateList`, "POST", params)
	},
	//学习认证结果
	userCertificateResult(params){
		return request(`${cffpURL}/certificate/userCertificateList`, "POST", params)
	},
	// 我的学习,学习记录
	userStudyList(params){
		return request(`${cffpURL}/study/userStudyList`, "POST", params)
	},
	// 我的分享
	userShareQuery(params){
		return request(`${cffpURL}/share/userShareQuery`, "POST", params)
	},
	// 订单详情
	userCourseInfo(params){
		return request(`${cffpURL}/course/userCourseInfo`, "POST", params)
	},
	//我的积分查询接口
	findByUserIdForFortuneStatistic(params){
		return request(`${apiURL}/fortune/findByUserIdForFortuneStatistic`, "POST", params)
	},
	//我的积分明细
	findForExchangeStatisticDtl(params){
		return request(`${apiURL}/fortune/findForExchangeStatisticDtl`, "POST", params)
	},
	//分类查询
	dropOptionsQuery(params){
		return request(`${apiURL}/metadata/dropOptionsQuery`, "POST", params)
	},
	// 销售课程统计
	userCourseCount(params){
		return request(`${cffpURL}/course/userCourseCount`, "POST", params)
	},
	// 销售课程列表查询
	userCourseList(params){
		return request(`${cffpURL}/course/userCourseList`, "POST", params)
	},
	// 分享课程列表查询
	userShareCourseList(params){
		return request(`${cffpURL}/course/userShareCourseList`, "POST", params)
	},
	//积分兑换查询
	queryByUserIdFortuneStatistic(params){
		return request(`${apiURL}/fortune/queryByUserIdFortuneStatistic`, "POST", params)
	},
	//积分兑换记录查询
	findByUserIdForWithdralHis(params){
		return request(`${apiURL}/fortune/findByUserIdForWithdralHis`, "POST", params)
	},
	//提现明细接口
	findByUserIdForWithdralDtl(params){
		return request(`${apiURL}/fortune/findByUserIdForWithdralDtl`, "POST", params)
	},
	// 我的售后
	userAfterSales(params){
		return request(`${cffpURL}/course/userAfterSales`, "POST", params)
	},
	// 售后详情
	userAfterSalesDtl(params){
		return request(`${cffpURL}/course/userAfterSalesDtl`, "POST", params)
	}
}
