// utils/crypto.js
import CryptoJS from 'crypto-js'

/**
 * 生成SHA-256签名
 * @param {string} userId 用户ID
 * @param {string|number} timestamp 时间戳
 * @param {string} signatureSecret 签名密钥
 * @returns {string} SHA-256加密后的16进制字符串
 */
export function generateSignature(userId, timestamp, signatureSecret) {
  // 拼接需要加密的字符串
  const content = `${userId}${timestamp}${signatureSecret}`
  
  // 使用SHA-256加密
  const hash = CryptoJS.SHA256(content)
  
  // 转换为16进制字符串
  return hash.toString(CryptoJS.enc.Hex)
}