// import {apiURL,cffpURL,sfpUrl} from "../environments/environment";
// import api from "@/api/api";

// // 白名单，不需要携带token就允许被访问的接口
// const whiteApiList = [
//   `${apiURL}/authorize/obtainToken`, 
//   `${apiURL}/authorize/checkToken`, 
//   `${cffpURL}/user/loginVerification`,
//   `${apiURL}/appVersion/checkIsUpdate`,
//   `${cffpURL}/accessLog/accessLogSave`,
//   `${cffpURL}/user/powerQuery`,
//   `${cffpURL}/user/wxLogin`,
//   `${cffpURL}/certificate/officialWebsiteDetail`,
//   `${apiURL}/verificationCode`,
//   `${sfpUrl}/sfp/sfpMain/pocessTracking`,
//   `${cffpURL}/partner/queryById`,
// ];

// // 判断是否为资源请求（图片、字体等）
// const isResourceRequest = (url) => {
//   const resourceExtensions = ['.png', '.jpg', '.jpeg', '.gif', '.bmp', '.webp', '.ttf', '.woff', '.woff2'];
//   return resourceExtensions.some(ext => url.includes(ext));
// };

// export const interceptor = () => {
//   uni.addInterceptor('request', {
//     // 请求拦截器
//     invoke(args) {
//       // 资源请求不添加认证头，避免触发OPTIONS预检请求
//       if (isResourceRequest(args.url)) {
//         // 对于资源请求，使用更简单的请求头
//         args.header = {
//           'content-type': 'application/x-www-form-urlencoded'
//         };
//         return;
//       }
      
//       // 当本地没有token，并且接口地址没在白名单内，需要重新获取token
//       if (!uni.getStorageSync('uni-token') && !whiteApiList.includes(args.url)) {
//         const params = {
//           ticket: 'uni-app',
//           loginId: null
//         }
//         let h5userId = uni.getStorageSync('cffp_userId');
        
//         if (h5userId) {
//           params.loginId = h5userId;
//         }
        
//         uni.request({
//           url: `${apiURL}/authorize/obtainToken`,
//           method: 'POST',
//           data: params,
//           success: (res) => {
//             if (res.statusCode === 200) {
//               uni.setStorageSync('uni-token', res.data['data']['token']);
//               let isHas = window.location.href.indexOf('?')==-1?'?':'&';
//               window.location.href = window.location.href + isHas + 't_reload=' + new Date().getTime();
//             }
//           }
//         })
//       }
      
//       // 设置API请求头及token
//       args.header = {
//         'content-type': args.method === 'POST' ? 'application/json' : 'application/x-www-form-urlencoded',
//         'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : '',
//       }
//     },
//     // 响应拦截器，可以对数据进行预处理
//     success(args) {
//       if(args && args.data && args.data.errorCode && "T001"==args.data.errorCode){
//         uni.removeStorageSync('isLogin');
//         uni.switchTab({
//           url:'/pages/index/index'
//         })
//       }
//     },
//     fail(err) {
//       console.log('interceptor-fail', err)
//     },
//     complete() {
//       // uni.hideLoading()
//     }
//   })
  
//   // 添加image拦截器，专门处理图片请求
//   uni.addInterceptor('image', {
//     invoke(args) {
//       // 图片请求使用简单请求头
//       args.header = {
//         'content-type': 'application/x-www-form-urlencoded'
//       };
//     }
//   });
// }


// 旧版的拦截器
import {apiURL,cffpURL,sfpUrl} from "../environments/environment";
 import api from "@/api/api";
// 白名单，不需要携带token就允许被访问的接口
const whiteApiList = [`${apiURL}/authorize/obtainToken`, 
					  `${apiURL}/authorize/checkToken`, 
					  `${cffpURL}/user/loginVerification`,
					  `${apiURL}/appVersion/checkIsUpdate`,
					  `${cffpURL}/accessLog/accessLogSave`,
					  `${cffpURL}/user/powerQuery`,`${cffpURL}/user/wxLogin`,
					  `${cffpURL}/certificate/officialWebsiteDetail`,
					  `${apiURL}/verificationCode`,
					  `${sfpUrl}/sfp/sfpMain/pocessTracking`,
					  `${cffpURL}/partner/queryById`,
					];
export const interceptor = () => {
	uni.addInterceptor('request', {
		// 请求拦截器
		invoke(args) {
			// 当本地没有token，并且接口地址没在白名单内，需要重新获取token
			if (!uni.getStorageSync('uni-token') && !whiteApiList.includes(args.url)) {
				
				const params = {
					ticket: 'uni-app',
					loginId: null
				}
				let h5userId = uni.getStorageSync('cffp_userId');
				
				if (h5userId) {
					params.loginId = h5userId;
					
				}
				uni.request({
					url: `${apiURL}/authorize/obtainToken`,
					method: 'POST',
					data: params,
					success: (res) => {
						if (res.statusCode === 200) {
							uni.setStorageSync('uni-token', res.data['data']['token']);
							let isHas = window.location.href.indexOf('?')==-1?'?':'&';
							window.location.href = window.location.href + isHas + 't_reload=' + new Date().getTime();
						}
					}
				})
			}
			//设置请求头及token
			args.header = {
				'content-type': args.method === 'POST' ? 'application/json' : 'application/x-www-form-urlencoded',
				'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : '',
				// 'Access-Control-Allow-Headers': 'appId',
				// 'Access-Control-Allow-Methods': 'POST, GET, OPTIONS',
				// 'Access-Control-Max-Age': 86400,
			}
		},
		// 响应拦截器，可以对数据进行预处理
		success(args) {
			if(args && args.data && args.data.errorCode && "T001"==args.data.errorCode){
				debugger;
				 uni.removeStorageSync('isLogin');
				 uni.removeStorageSync('uni-token');
				 uni.switchTab({
					url:'/pages/index/index'
				})
			}
		},
		fail() {
			// console.log('interceptor-fail', err)
		},
		complete() {
			// uni.hideLoading()
		}
	})
}
