import Painter from "../painter";
import { BaseLine, FillStrokeStyle, TextAlign } from "../value";
import { PainterContext } from "./index";
declare const PainterH5Context_base: new (prototype: CanvasRenderingContext2D) => CanvasRenderingContext2D & {
    context: CanvasRenderingContext2D;
};
export declare class PainterH5Context extends PainterH5Context_base implements PainterContext {
    private painter;
    constructor(painter: Painter, context: CanvasRenderingContext2D);
    draw(reserve: boolean, callback: () => void): void;
    setFillStyle(color: FillStrokeStyle): void;
    setStrokeStyle(color: FillStrokeStyle): void;
    drawImageWithSrc(imageResource: string, sx: number, sy: number, sWidth: number, sHeight: number, dx?: number, dy?: number, dWidth?: number, dHeight?: number): Promise<void>;
    setTextAlign(align: TextAlign): void;
    setTextBaseline(baseline: BaseLine): void;
    setFontSize(fontSize: number): void;
    measureTextWidth(text: string, fontSize: number): number;
}
export declare function normalizeImageResource(src: string): Promise<HTMLImageElement>;
export {};
