export default {
  mobileNoValid(no) {
    const MOBILE_REGEXP = /^(1)\d{10}$/;
    return MOBILE_REGEXP.test(no);
  },
  passwordValid(no) {
    const PASSWOED_REGEXP = /^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,12}$/;
    return PASSWOED_REGEXP.test(no);
  },
  getQueryString(name){
      const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
      const r = decodeURIComponent(window.location.search).substr(1).match(reg);
      if (r != null) {
        return r[2];
      }
      return null;
  },
  
  // 封装报错弹窗
  errorDialog(type,content,title=null){
  	// type 1 必填项校验 2 规则校验
  	uni.showModal({
  	  title: title ? title : (type===1 ? '必填项校验' : '规则校验'),
  	  content:content,
  	  showCancel:false,
  	  success: function (res) {
  			  if (res.confirm) {
  					  console.log('用户点击确定');
  			  } else if (res.cancel) {
  					  console.log('用户点击取消');
  			  }
  	  }
  	});
  },
  // 下拉选单通过code获取name
  getNameByCode(code:String,arr:Array<any>){
	  if(arr &&  arr.filter(item=>item.dropOptionCode == code).pop()){
		 return arr.filter(item=>item.dropOptionCode == code).pop().dropOptionName
	  }else{
		  return;
	  }
  },
     /**
     * 身份证号码校验，并获取生日、性别、年龄
     * @param code
     * @returns {{pass: boolean, msg: string, birthDay: number, gender: null, age: null, ageUnit: string}}
     * @constructor
     */
    IdCodeValid(code) {
      if (code) {
        // 身份证号合法性验证
        // 支持15位和18位身份证号
        // 支持地址编码、出生日期、校验位验证
        const city = {
          11: '北京',
          12: '天津',
          13: '河北',
          14: '山西',
          15: '内蒙古',
          21: '辽宁',
          22: '吉林',
          23: '黑龙江 ',
          31: '上海',
          32: '江苏',
          33: '浙江',
          34: '安徽',
          35: '福建',
          36: '江西',
          37: '山东',
          41: '河南',
          42: '湖北 ',
          43: '湖南',
          44: '广东',
          45: '广西',
          46: '海南',
          50: '重庆',
          51: '四川',
          52: '贵州',
          53: '云南',
          54: '西藏 ',
          61: '陕西',
          62: '甘肃',
          63: '青海',
          64: '宁夏',
          65: '新疆',
          81: '香港',
          82: '澳门',
          83: '台湾',
          91: '国外 '
        };
        // 出生年月日校验   前正则限制起始年份为1900;
        const year = code.substr(6, 4); // 身份证年
        const month = code.substr(10, 2); // 身份证月
        const date = code.substr(12, 2); // 身份证日
        const birth = new Date(year + '-' + month + '-' + date);
        const time = Date.parse(year + '-' + month + '-' + date); // 身份证日期时间戳date
        const now_time = Date.parse(new Date().toDateString());
        const dates = (new Date(year, month, 0)).getDate(); // 身份证当月天数
        const gender = code.substr(16, 1);
        let row = {
          'pass': true,
          'msg': '验证成功',
          'birthDay': time,
          'gender': null,
        };
        if (parseInt(gender % 2 + '', 0) === 1) {
          row.gender = '1';
        } else {
          row.gender = '2';
        }
        if (!code || !/^\d{6}(19|20)?\d{2}(0[1-9]|1[012])(0[1-9]|[12]\d|3[01])\d{3}(\d|[xX])$/.test(code)) {
          row = {
            'pass': false,
            'msg': '身份证号格式错误',
            'birthDay': null,
            'gender': null,
          };
        } else if (!city[code.substr(0, 2)]) {
          row = {
            'pass': false,
            'msg': '身份证号地址编码错误',
            'birthDay': null,
            'gender': null,
          };
        } else if (time > now_time || date > dates) {
          row = {
            'pass': false,
            'msg': '出生日期不合规',
            'birthDay': null,
            'gender': null,
          }
        } else {
          // 18位身份证需要验证最后一位校验位
          if (code.length == 18) {
            code = code.split('');
            // ∑(ai×Wi)(mod 11)
            // 加权因子
            const factor = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
            // 校验位
            const parity = [1, 0, 'X', 9, 8, 7, 6, 5, 4, 3, 2];
            let sum = 0;
            let ai = 0;
            let wi = 0;
            for (let i = 0; i < 17; i++) {
              ai = code[i];
              wi = factor[i];
              sum += ai * wi;
            }
            if (parity[sum % 11] != code[17].toUpperCase()) {
              row = {
                'pass': false,
                'msg': '身份证号校验位错误',
                'birthDay': null,
                'gender': null,
              };
            }
          }
        }
        return row;
      }
    },
  
      /**
     * 姓名正则(包含公司名)
     */
    nameValid(name) {
      const NAME_REGEXP = /(^[\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\.·()（）。]{0,48}[\u4e00-\u9fa5]{1}$)|(^[a-zA-Z]{1}[a-zA-Z\s]{0,48}[a-zA-Z]{1}$)/;
      return NAME_REGEXP.test(name);
    },
    /**
     * 邮箱正则
     */
    emailValid(email) {
      const EMAIL_REGEXP = /^(\w-*\.*)+@(\w-?)+(\.\w{2,})+$/;
      return EMAIL_REGEXP.test(email);
    },
    //检测字符串是否只有中文、英文、数字
    checkCEN(val) {
      const cen_reg = /^[A-Za-z0-9\u4e00-\u9fa5]+$/;
      return cen_reg.test(val);
    },
    /**
     * 检测统一社会信用代码只能是数字和字母
     * @param val
     * @returns {boolean}
     */
    checkTaxNo(val) {
      const taxNo_reg = /[a-zA-Z0-9]{5,20}/;
      return taxNo_reg.test(val);
    }
  
}