import api from "@/api/api";
//只要是未登录状态，想要跳转到名单内的路径时，直接跳到登录页
// 页面白名单，不受拦截
const whiteList = [
	'/components/login/login',
	'/pages/invitationRegister/invitationlogin',
	'/components/clause/clause',
	'/pages/orderDetail/orderDetail',
	'/pages/courseDetail/courseDetail',
	'/pages/courselist/courselist',
	'/pages/personalCenter/helpCenter',
	'/pages/index/index'
]
export default function initApp(){
	uni.addInterceptor('navigateTo', {
	    // 页面跳转前进行拦截, invoke根据返回值进行判断是否继续执行跳转
	    invoke (e) {
			if(!uni.getStorageSync('loginType')){
				 uni.clearStorageSync();
				 uni.setStorageSync('loginType','visitor')
				 uni.redirectTo({
				     url: '/components/login/login'
				 })
			}
			if(uni.getStorageSync('cffp_userId')){
				api.queryInfo({userId:uni.getStorageSync('cffp_userId')}).then(res=>{
					if(!res['success']){
						// 清空全部本地存储
						uni.clearStorageSync();
						uni.setStorageSync('loginType','visitor')
						uni.redirectTo({
						    url: '/components/login/login'
						})
						
						return
					}
					
				})
			}
			let whiteArr = ['index','personalCenter','courselist','product']
			// 1. 解析 URL 中的 from 参数
			    const getQueryParam = (url, key) => {
			      const queryString = url.split('?')[1];
			      if (!queryString) return null;
			      const params = new URLSearchParams(queryString);
			      return params.get(key);
			    };
		
			    const fromParam = getQueryParam(e.url, 'from');
				
	        if(!hasPermission(e.url)){
				// 如果 from 参数在 whiteArr 中，说明是tabbar页带着tabbar的标志参数跳转到登录页，以便未登录状态下回到对应的tabbar页
				      if (fromParam && whiteArr.includes(fromParam)) {
				        uni.redirectTo({
				            url: `/components/login/login?from=${fromParam}`				        
							})
				      }else {
						  uni.redirectTo({
						      url: '/components/login/login'
						  })
					  }
	           
	            return false
	        }
	        return true
	    },
	    success (e) {
	    }
	})
	 //最新 修改 tabbar页面跳转前不进行拦截
	// uni.addInterceptor('switchTab', {
	//     
	//     invoke (e) {
	// 		console.log('!hasPermission(e.url)',e.url);
	//         if(!hasPermission(e.url)){
	//             uni.redirectTo({
	//                 url: '/components/login/login'
	//             })
	//             return false
	//         }
	//         return true
	//     },
	//     success (e) {
	//     }
	// })
}
function hasPermission (url) {
	let islogin = uni.getStorageSync("isLogin");//在这可以使用token、vuex
	// islogin = Boolean(Number(islogin));//返回布尔值
    // 在白名单中或有登录判断条件可以直接跳转
	
    if(whiteList.indexOf(url.slice(0,url.indexOf('?'))) !== -1 || islogin) {
        return true
    }
    return false
}