import request from "../util/request";
import {baseURL,apiURL,cffpURL} from "../environments/environment";

export default {
	//查看token是否已经失效
	checkToken(){
		const params = {
			token:uni.getStorageSync('uni-token'),
			ticket:'uni-app'
		}
		return request(`${baseURL}/api/authorize/checkToken`, "POST", params)
	},
	// 获取token
	obtainToken(){
		const params = {
			ticket:'uni-app'
		}
		return request(`${baseURL}/api/authorize/obtainToken`, "POST", params)
	},
	//获取验证码
	verificationCode(params){
		return request(`${baseURL}/api/verificationCode`, "POST", params)
	},
	//登录接口
	loginVerification(params){
		return request(`${cffpURL}/user/loginVerification`, "POST", params)
	},
	//注册接口
	register(params){
		return request(`${cffpURL}/user/register`, "POST", params)
	},
	//重置密码
	resetPassword(params){
		return request(`${cffpURL}/user/resetPassword`, "POST", params)
	},
	// 课程查询列表接口
	courseList(params){
		return request(`${cffpURL}/course/list`,"POST",params)
	},
	// 讲师信息查询
	lecturerQuery(params){
		return request(`${apiURL}/college/lecturerQuery`, "POST", params)
	},
	//账户信息获取
	queryAreaCenterInfo(params){
		return request(`${cffpURL}/areaCenter/queryAreaCenterInfo`, "POST", params)
	},
	//公告列表
	announcementQuery(params){
		return request(`${baseURL}/ydapi/market/announcementQuery`, "POST", params)
	},
	//消息列表
	querySystemMessage(params){
		return request(`${apiURL}/systemMessage/querySystemMessage`, "POST", params)
	},
	//清除站内消息
	oneKeyRead(params){
		return request(`${apiURL}/systemMessage/oneKeyRead`, "POST", params)
	},
	//消息详情&单个阅读
	querySystemMessageDetail(params){
		return request(`${apiURL}/systemMessage/querySystemMessageDetail`, "POST", params)
	},
	// 学习认证列表
	querySignupList(params){
		return request(`${cffpURL}/certificate/querySignupList`, "POST", params)
	},
	// 个人认证列表
	userCertificateList(params){
		return request(`${cffpURL}/certificate/userCertificateList`, "POST", params)
	},
	// 认证详情
	queryCertificateInfo(params){
		return request(`${cffpURL}/certificate/queryCertificateInfo`, "POST", params)
	},
	// 课程详情
	courseDetail(params){
		return request(`${cffpURL}/course/detail`, "POST", params)
	},
	// 相关课程黎贝澳查询
	relatedCoursesList(params){
		return request(`${cffpURL}/course/relatedCoursesList`, "POST", params)
	},
	//邀请加盟与申请加盟保存接口
	saveApplyInfo(params){
		return request(`${cffpURL}/partner/saveApplyInfo`, "POST", params)
	},
	//学习认证列表
	queryCertificateList(params){
		return request(`${cffpURL}/certificate/queryCertificateList`, "POST", params)
	},
	//学习认证结果
	userCertificateResult(params){
		return request(`${cffpURL}/certificate/userCertificateList`, "POST", params)
	},
	// 我的学习,学习记录
	userStudyList(params){
		return request(`${cffpURL}/study/userStudyList`, "POST", params)
	},
	// 我的分享
	userShareQuery(params){
		return request(`${cffpURL}/share/userShareQuery`, "POST", params)
	},
	// 订单详情
	userCourseInfo(params){
		return request(`${cffpURL}/course/userCourseInfo`, "POST", params)
	},
	//我的积分查询接口
	findByUserIdForFortuneStatistic(params){
		return request(`${apiURL}/fortune/findByUserIdForFortuneStatistic`, "POST", params)
	},
	//我的积分明细
	findForExchangeStatisticDtl(params){
		return request(`${apiURL}/fortune/findForExchangeStatisticDtl`, "POST", params)
	},
	//分类查询
	dropOptionsQuery(params){
		return request(`${apiURL}/metadata/dropOptionsQuery`, "POST", params)
	},
	// 销售课程统计
	userCourseCount(params){
		return request(`${cffpURL}/course/userCourseCount`, "POST", params)
	},
	// 销售课程列表查询
	userCourseList(params){
		return request(`${cffpURL}/course/userCourseList`, "POST", params)
	},
	// 分享课程列表查询
	userShareCourseList(params){
		return request(`${cffpURL}/course/userShareCourseList`, "POST", params)
	},
	//积分兑换查询
	queryByUserIdFortuneStatistic(params){
		return request(`${apiURL}/fortune/queryByUserIdFortuneStatistic`, "POST", params)
	},
	//积分兑换记录查询
	findByUserIdForWithdralHis(params){
		return request(`${apiURL}/fortune/findByUserIdForWithdralHis`, "POST", params)
	},
	//提现明细接口
	findByUserIdForWithdralDtl(params){
		return request(`${apiURL}/fortune/findByUserIdForWithdralDtl`, "POST", params)
	},
	// 我的售后
	userAfterSales(params){
		return request(`${cffpURL}/course/userAfterSales`, "POST", params)
	},
	// 售后详情
	userAfterSalesDtl(params){
		return request(`${cffpURL}/course/userAfterSalesDtl`, "POST", params)
	},
	// 个人信息查询
	queryInfo(params){
		return request(`${cffpURL}/user/queryInfo`, "POST", params)
	},
	// 微信支付
	wxAppPay(params){
		return request(`${apiURL}/pay/wxAppPay`, "POST", params)
	},
	// 订单保存
	saveOrder(params){
		return request(`${cffpURL}/order/saveOrder`, "POST", params)
	},
	//去提现接口
	goFortuneWithdrawal(params){
		return request(`${apiURL}/fortune/goFortuneWithdrawal`, "POST", params)
	},
	// 支付宝支付
	aliAppPay(params){
		return request(`${apiURL}/aliPay/aliAppPay`, "POST", params)
	},
	// 分享链接列表
	userShareLinkList(params){
		return request(`${cffpURL}/share/userShareLinkList`, "POST", params)
	},
	// 分享阅读列表
	userShareReadList(params){
		return request(`${cffpURL}/share/userShareReadList`, "POST", params)
	},
	// 分享购买列表
	userShareBuyList(params){
		return request(`${cffpURL}/share/userShareBuyList`, "POST", params)
	},
	// 我的分享统计
	userShareCount(params){
		return request(`${cffpURL}/share/userShareCount`, "POST", params)
	},
	// 退课明细
	userRefundCourseDtl(params){
		return request(`${cffpURL}/course/userRefundCourseDtl`, "POST", params)
	},
	// 支付宝支付->app退款接口
	aliAppPayRefund(params){
		return request(`${apiURL}/aliPay/aliAppPayRefund`, "POST", params)
	},
	//查询证件类型
	erpInitialize(params){
		return request(`${apiURL}/erp/erpInitialize`, "POST", params)
	},
	//获取职业类别
	occupationQry(params){
		return request(`${apiURL}/metadata/occupationQry`, "POST", params)
	},
	// 邀请列表查询
	queryInviteList(params){
		return request(`${cffpURL}/partner/queryInviteList`, "POST", params)
	},
	// 视频播放轨迹保存
	saveVideoPlayback(params){
		return request(`${apiURL}/videoPlay/saveVideoPlayback`, "POST", params)
	},
	// 查询视频播放最新记录
	findVideoPlayback(params){
		return request(`${apiURL}/videoPlay/findVideoPlayback`, "POST", params)
	},
	// 教育等级查询
	educationLevelQuery() {
		return request(`${apiURL}/metadata/educationLevelQuery`, "GET")
	},
	// 退课列表
	queryDropCourseList(params){
		return request(`${cffpURL}/course/queryDropCourseList`, "POST", params)
	},
	// 我的团队
	queryMyTeamInfo(params){
		return request(`${cffpURL}/cffp/orgInfo/queryMyTeamInfo`, "POST", params)
	},
	// 学习统计
	userStudyCount(params){
		return request(`${cffpURL}/study/userStudyCount`, "POST", params)
	},
	// 课程包学习进度明细
	userCoursePackBar(params){
		return request(`${cffpURL}/study/userCoursePackBar`, "POST", params)
	},
	// 学习明细
	userStudyTime(params){
		return request(`${cffpURL}/study/userStudyTime`, "POST", params)
	},
	//合同声明
	listQuery(params){
		return request(`${cffpURL}/contract/listQuery`, "POST", params)
	}
}
