var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
if (typeof Promise !== "undefined" && !Promise.prototype.finally) {
  Promise.prototype.finally = function(callback) {
    const promise = this.constructor;
    return this.then((value) => promise.resolve(callback()).then(() => value), (reason) => promise.resolve(callback()).then(() => {
      throw reason;
    }));
  };
}
;
if (typeof uni !== "undefined" && uni && uni.requireGlobal) {
  const global = uni.requireGlobal();
  ArrayBuffer = global.ArrayBuffer;
  Int8Array = global.Int8Array;
  Uint8Array = global.Uint8Array;
  Uint8ClampedArray = global.Uint8ClampedArray;
  Int16Array = global.Int16Array;
  Uint16Array = global.Uint16Array;
  Int32Array = global.Int32Array;
  Uint32Array = global.Uint32Array;
  Float32Array = global.Float32Array;
  Float64Array = global.Float64Array;
  BigInt64Array = global.BigInt64Array;
  BigUint64Array = global.BigUint64Array;
}
;
if (uni.restoreGlobal) {
  uni.restoreGlobal(Vue, weex, plus, setTimeout, clearTimeout, setInterval, clearInterval);
}
(function(vue) {
  "use strict";
  function formatAppLog(type, filename, ...args) {
    if (uni.__log__) {
      uni.__log__(type, filename, ...args);
    } else {
      console[type].apply(console, [...args, filename]);
    }
  }
  const whiteApiList = [`/api/authorize/obtainToken`, `/api/authorize/checkToken`];
  const interceptor = () => {
    uni.addInterceptor("request", {
      invoke(args) {
        formatAppLog("log", "at util/interceptor.ts:13", "\u8BF7\u6C42\u62E6\u622A\u5668", args);
        uni.showLoading({
          title: "\u52A0\u8F7D\u4E2D..."
        });
        if (!uni.getStorageSync("uni-token") && !whiteApiList.includes(args.url)) {
          formatAppLog("log", "at util/interceptor.ts:20", "-----------");
          return new Promise((resolve, reject) => {
            uni.request({
              url: "/api/authorize/obtainToken",
              method: "POST",
              data: { ticket: "uni-app" },
              success: (res) => {
                if (res.statusCode === 200) {
                  uni.setStorageSync("uni-token", res.data["data"]["token"]);
                  window.location.href = window.location.href + "?t_reload=" + new Date().getTime();
                }
                formatAppLog("log", "at util/interceptor.ts:31", res);
              },
              fail(err) {
                reject(err);
              }
            });
            uni.hideLoading();
            return false;
          });
        }
        args.header = {
          "content-type": args.method === "POST" ? "application/json" : "application/x-www-form-urlencoded",
          "X-Authorization": uni.getStorageSync("uni-token")
        };
      },
      success(args) {
        uni.hideLoading();
      },
      fail(err) {
        formatAppLog("log", "at util/interceptor.ts:56", "interceptor-fail", err);
        formatAppLog("log", "at util/interceptor.ts:57", "\u8BF7\u6C42\u5931\u8D25");
        uni.hideLoading();
      },
      complete(res) {
        uni.hideLoading();
      }
    });
  };
  var request = (url, method, params) => {
    interceptor();
    return new Promise((resolve, reject) => {
      uni.request({
        url,
        method,
        data: __spreadValues({}, params),
        success(res) {
          resolve(res.data);
        },
        fail(err) {
          reject(err);
        },
        complete() {
          uni.hideLoading();
        }
      });
    });
  };
  const dev = {
    base_url: "https://mdev.zuihuibi.cn",
    api_url: "https://mdev.zuihuibi.cn/api",
    sfp_url: "https://mdev.zuihuibi.cn/api/sfp"
  };
  const stage = {
    base_url: "https://mstage.zuihuibi.cn",
    api_url: "https://mstage.zuihuibi.cn/api",
    sfp_url: "https://mstage.zuihuibi.cn/api/sfp"
  };
  const prod = {
    base_url: "https://m.zuihuibi.cn",
    api_url: "https://m.zuihuibi.cn/api",
    sfp_url: "https://m.zuihuibi.cn/api/sfp"
  };
  const config = {
    dev,
    stage,
    prod
  };
  let env = "dev";
  let baseURL = config[env].base_url;
  var api = {
    checkToken() {
      const params = {
        token: uni.getStorageSync("uni-token"),
        ticket: "uni-app"
      };
      return request(`${baseURL}/api/authorize/checkToken`, "POST", params);
    },
    obtainToken() {
      const params = {
        ticket: "uni-app"
      };
      return request(`${baseURL}/api/authorize/obtainToken`, "POST", params);
    },
    verificationCode(params) {
      return request(`${baseURL}/api/verificationCode`, "POST", params);
    },
    loginVerification(params) {
      return request(`${baseURL}/api/verificationCode`, "POST", params);
    }
  };
  var common = {
    mobileNoValid(no) {
      const MOBILE_REGEXP = /^(1)\d{10}$/;
      return MOBILE_REGEXP.test(no);
    },
    errorDialog(type, content) {
      uni.showModal({
        title: type === 1 ? "\u5FC5\u586B\u9879\u6821\u9A8C" : "\u89C4\u5219\u6821\u9A8C",
        content,
        showCancel: false,
        success: function(res) {
          if (res.confirm) {
            formatAppLog("log", "at common/common.ts:15", "\u7528\u6237\u70B9\u51FB\u786E\u5B9A");
          } else if (res.cancel) {
            formatAppLog("log", "at common/common.ts:17", "\u7528\u6237\u70B9\u51FB\u53D6\u6D88");
          }
        }
      });
    }
  };
  var _export_sfc = (sfc, props) => {
    const target = sfc.__vccOpts || sfc;
    for (const [key, val] of props) {
      target[key] = val;
    }
    return target;
  };
  const _sfc_main$1 = {
    data() {
      return {
        loginType: "codelogin",
        passwordFlag: false,
        loginTypeName: "\u9A8C\u8BC1\u7801\u767B\u5F55",
        remainTimes: 60,
        sendCodeHtml: "\u83B7\u53D6\u9A8C\u8BC1\u7801",
        form: {
          mobile: null,
          code: null,
          password: null,
          invitation_code: null
        },
        disabledSendBtn: false
      };
    },
    methods: {
      formReset: function(e) {
        formatAppLog("log", "at components/login/login.vue:96", "\u6E05\u7A7A\u6570\u636E");
      },
      getLogin() {
        this.loginType === "codelogin" ? this.loginType = "pwlogin" : this.loginType = "codelogin";
        this.loginTypeName = this.loginType == "codelogin" ? "\u9A8C\u8BC1\u7801\u767B\u5F55" : "\u5BC6\u7801\u767B\u5F55";
      },
      register() {
        this.loginType === "register" ? this.loginType = "resetpw" : this.loginType = "register";
        this.loginTypeName = this.loginType == "register" ? "\u6CE8\u518C" : "\u91CD\u7F6E\u5BC6\u7801";
      },
      sendMessage() {
        debugger;
        const params = {
          mobileNo: this.form.mobile,
          type: "1"
        };
        if (common.mobileNoValid(this.form.mobile) && !this.disabledSendBtn) {
          api.verificationCode(params).then((res) => {
            formatAppLog("log", "at components/login/login.vue:114", res);
            if (res["success"]) {
              this.delayTime();
            }
          });
        } else {
          common.errorDialog(2, "\u624B\u673A\u53F7\u6821\u9A8C\u9519\u8BEF");
        }
      },
      delayTime() {
        this.disabledSendBtn = true;
        this.timer = setInterval(() => {
          this.remainTimes--;
          this.sendCodeHtml = `${this.remainTimes}(S)`;
          if (this.remainTimes <= 0) {
            this.sendCodeHtml = "\u83B7\u53D6\u9A8C\u8BC1\u7801";
            this.remainTimes = 60;
            this.disabledSendBtn = false;
            clearInterval(this.timer);
          }
        }, 1e3);
      }
    },
    mounted() {
      api.obtainToken().then((res) => {
        formatAppLog("log", "at components/login/login.vue:141", res);
      });
    }
  };
  function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("view", { class: "wrapper" }, [
      vue.createElementVNode("view", { class: "logo" }, [
        vue.createElementVNode("img", {
          src: "/static/logo.png",
          alt: "logo",
          srcset: ""
        }),
        vue.createElementVNode("view", null, "\u6B22\u8FCE\u767B\u5F55\u4F7F\u7528CFFP")
      ]),
      vue.createElementVNode("view", { class: "content" }, [
        vue.createElementVNode("view", { class: "login_title" }, vue.toDisplayString($data.loginTypeName), 1),
        vue.createElementVNode("form", null, [
          $data.loginType === "register" ? (vue.openBlock(), vue.createElementBlock("view", {
            key: 0,
            class: "inputItem"
          }, [
            vue.createElementVNode("input", {
              class: "uni-input",
              name: "invitationCode",
              placeholder: "\u8F93\u5165\u9080\u8BF7\u7801(\u975E\u5FC5\u586B)"
            })
          ])) : vue.createCommentVNode("v-if", true),
          vue.createElementVNode("view", { class: "inputItem" }, [
            vue.withDirectives(vue.createElementVNode("input", {
              class: "uni-input",
              name: "mobileNo",
              placeholder: "\u8F93\u5165\u624B\u673A\u53F7",
              "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $data.form.mobile = $event),
              maxlength: "11"
            }, null, 512), [
              [vue.vModelText, $data.form.mobile]
            ])
          ]),
          $data.loginType === "codelogin" || $data.loginType === "register" || $data.loginType === "resetpw" ? (vue.openBlock(), vue.createElementBlock("view", {
            key: 1,
            class: "inputItem"
          }, [
            vue.withDirectives(vue.createElementVNode("input", {
              class: "uni-input",
              name: "code",
              placeholder: "\u8F93\u5165\u9A8C\u8BC1\u7801",
              "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => $data.form.code = $event),
              type: "number"
            }, null, 512), [
              [vue.vModelText, $data.form.code]
            ]),
            vue.createElementVNode("text", {
              onClick: _cache[2] || (_cache[2] = ($event) => $options.sendMessage()),
              class: vue.normalizeClass({ "grey": $data.disabledSendBtn })
            }, vue.toDisplayString($data.sendCodeHtml), 3)
          ])) : vue.createCommentVNode("v-if", true),
          $data.loginType === "pwlogin" || $data.loginType === "register" ? (vue.openBlock(), vue.createElementBlock("view", {
            key: 2,
            class: "inputItem"
          }, [
            !$data.passwordFlag ? (vue.openBlock(), vue.createElementBlock("input", {
              key: 0,
              class: "uni-input",
              type: "text",
              name: "password",
              placeholder: "\u8F93\u5165\u5BC6\u7801"
            })) : vue.createCommentVNode("v-if", true),
            $data.passwordFlag ? (vue.openBlock(), vue.createElementBlock("input", {
              key: 1,
              class: "uni-input",
              type: "text",
              password: "",
              name: "password",
              placeholder: "\u8F93\u5165\u5BC6\u7801"
            })) : vue.createCommentVNode("v-if", true),
            $data.passwordFlag ? (vue.openBlock(), vue.createElementBlock("text", {
              key: 2,
              onClick: _cache[3] || (_cache[3] = ($event) => $data.passwordFlag = false)
            }, "\u663E\u793A\u5BC6\u7801")) : vue.createCommentVNode("v-if", true),
            !$data.passwordFlag ? (vue.openBlock(), vue.createElementBlock("text", {
              key: 3,
              onClick: _cache[4] || (_cache[4] = ($event) => $data.passwordFlag = true)
            }, "\u4E0D\u663E\u793A\u5BC6\u7801")) : vue.createCommentVNode("v-if", true)
          ])) : vue.createCommentVNode("v-if", true),
          vue.createCommentVNode("\u91CD\u7F6E\u5BC6\u7801"),
          $data.loginType === "resetpw" ? (vue.openBlock(), vue.createElementBlock("view", { key: 3 }, [
            vue.createElementVNode("view", { class: "inputItem" }, [
              vue.createElementVNode("input", {
                class: "uni-input",
                type: "text",
                password: "",
                name: "password",
                placeholder: "\u5BC6\u7801(6-20\u4F4D\u5B57\u6BCD\u6570\u5B57\u7EC4\u5408)"
              })
            ]),
            vue.createElementVNode("view", { class: "inputItem" }, [
              vue.createElementVNode("input", {
                class: "uni-input",
                type: "text",
                password: "",
                name: "password",
                placeholder: "\u518D\u6B21\u786E\u8BA4\u5BC6\u7801"
              })
            ])
          ])) : vue.createCommentVNode("v-if", true)
        ]),
        $data.loginType != "resetpw" ? (vue.openBlock(), vue.createElementBlock("view", {
          key: 0,
          class: "agree"
        }, [
          vue.createElementVNode("icon", {
            type: _ctx.radioUnselect,
            size: "26"
          }, null, 8, ["type"]),
          vue.createElementVNode("text", null, "\u5DF2\u9605\u8BFB\u5E76\u540C\u610F"),
          vue.createElementVNode("a", { href: "#" }, "\u94F6\u76FE\u4FDD\u9669\u7ECF\u7EAA\u670D\u52A1\u534F\u8BAE"),
          vue.createElementVNode("text", null, "\u548C"),
          vue.createElementVNode("a", { href: "" }, "\u9690\u79C1\u653F\u7B56")
        ])) : vue.createCommentVNode("v-if", true),
        $data.loginType != "resetpw" ? (vue.openBlock(), vue.createElementBlock("view", {
          key: 1,
          class: "login_btn",
          onClick: _cache[5] || (_cache[5] = ($event) => _ctx.loginIn())
        }, vue.toDisplayString($data.loginType == "register" ? "\u6CE8\u518C" : "\u767B\u5F55") + " " + vue.toDisplayString($data.loginType), 1)) : vue.createCommentVNode("v-if", true),
        $data.loginType == "resetpw" ? (vue.openBlock(), vue.createElementBlock("view", {
          key: 2,
          class: "login_btn"
        }, " \u4FDD\u5B58 ")) : vue.createCommentVNode("v-if", true),
        $data.loginType != "resetpw" ? (vue.openBlock(), vue.createElementBlock("view", {
          key: 3,
          class: "login_type"
        }, [
          vue.createElementVNode("text", {
            onClick: _cache[6] || (_cache[6] = ($event) => $options.getLogin())
          }, vue.toDisplayString($data.loginType == "pwlogin" || $data.loginType == "register" ? "\u9A8C\u8BC1\u7801\u767B\u5F55" : "\u5BC6\u7801\u767B\u5F55"), 1),
          vue.createElementVNode("text", {
            onClick: _cache[7] || (_cache[7] = ($event) => $options.register())
          }, vue.toDisplayString($data.loginType == "codelogin" ? "\u7ACB\u5373\u6CE8\u518C" : "\u5FD8\u8BB0\u5BC6\u7801"), 1)
        ])) : vue.createCommentVNode("v-if", true),
        $data.loginType != "resetpw" ? (vue.openBlock(), vue.createElementBlock("view", { key: 4 }, [
          vue.createElementVNode("view", { class: "other_login" }, [
            vue.createElementVNode("text", { class: "text_line" }),
            vue.createElementVNode("text", { style: { "margin": "0 40rpx", "position": "relative", "top": "10rpx" } }, "\u5176\u4ED6\u767B\u5F55"),
            vue.createElementVNode("text", { class: "text_line" })
          ]),
          vue.createElementVNode("view", { class: "login_type" }, [
            vue.createElementVNode("text", null, "\u6E38\u5BA2"),
            vue.createElementVNode("text", null, "\u4EE3\u7406\u5546")
          ])
        ])) : vue.createCommentVNode("v-if", true)
      ])
    ]);
  }
  var ComponentsLoginLogin = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["render", _sfc_render], ["__file", "E:/work/cffp/components/login/login.vue"]]);
  __definePage("components/login/login", ComponentsLoginLogin);
  const _sfc_main = {
    onLaunch: function() {
      formatAppLog("log", "at App.vue:4", "App Launch");
    },
    onShow: function() {
      formatAppLog("log", "at App.vue:7", "App Show");
    },
    onHide: function() {
      formatAppLog("log", "at App.vue:10", "App Hide");
    }
  };
  var App = /* @__PURE__ */ _export_sfc(_sfc_main, [["__file", "E:/work/cffp/App.vue"]]);
  function createApp() {
    const app = vue.createVueApp(App);
    return {
      app
    };
  }
  const { app: __app__, Vuex: __Vuex__, Pinia: __Pinia__ } = createApp();
  uni.Vuex = __Vuex__;
  uni.Pinia = __Pinia__;
  __app__.provide("__globalStyles", __uniConfig.styles);
  __app__._component.mpType = "app";
  __app__._component.render = () => {
  };
  __app__.mount("#app");
})(Vue);
