
export default{
	// 粗略的验证地址
	validateDetailAddress(address) {
		  // 验证是否包含省市区信息
		  const provinceCityRegex = /(省|自治区|直辖市|市|区|县|自治州|盟|旗)/;
		  
		  // 验证详细地址格式（门牌号等）
		  const detailRegex = /^[\u4e00-\u9fa5a-zA-Z0-9\-\.\/号栋单元室房层]+$/;
		  
		  if (!provinceCityRegex.test(address)) {
			  uni.showToast({title: '地址中应包含省市区信息',duration: 2000,icon: 'none'});
			return false
		  }
		  
		  if (!detailRegex.test(address)) {
			   uni.showToast({title: '详细地址格式不正确',duration: 2000,icon: 'none'});
			return false
		  }
		  
		  return true
	},
	validateBankCard(cardNumber) {
	  // 1. 去除空格和特殊字符
	  const cleanNumber = cardNumber.replace(/\s+/g, '');
	  
	  // 2. 基础校验（位数+纯数字）
	  if (!/^\d{13,19}$/.test(cleanNumber)) {
	    return {msg:'银行卡号应为13-19位数字',flag:false}
	  }
	  
	  // 3. Luhn算法校验（验证卡号有效性）
	  // let sum = 0;
	  // for (let i = 0; i < cleanNumber.length; i++) {
	  //   let digit = parseInt(cleanNumber.charAt(i));
	  //   if ((cleanNumber.length - i) % 2 === 0) {
	  //     digit *= 2;
	  //     if (digit > 9) digit -= 9;
	  //   }
	  //   sum += digit;
	  // }
	  
	  // if (sum % 10 !== 0) {
	  //   return '银行卡号校验失败，请检查';
	  // }
	  
	  return {flag:true}; // 验证通过
	},
	/**
	   * 姓名正则
	   */
	  nameValid(name) {
	    const NAME_REGEXP = /(^[\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\.·()（）。]{0,48}[\u4e00-\u9fa5]{1}$)|(^[a-zA-Z]{1}[a-zA-Z\s]{0,48}[a-zA-Z]{1}$)/;
	    return NAME_REGEXP.test(name);
	  },
/**
   * 护照校验
   * 只能是5到17位的数字和字母
   * @param val
   */
  passportValid(val) {
    const PASSPORT_REGEXP = /^[a-zA-Z0-9]{8,9}$/;
    return PASSPORT_REGEXP.test(val);
  },
/**
   * 邮箱正则
   */
  emailValid(email) {
    const EMAIL_REGEXP = /^(\w-*\.*)+@(\w-?)+(\.\w{2,})+$/;
    return EMAIL_REGEXP.test(email);
  },
mobileNoValid(no) {
    const MOBILE_REGEXP = /^(1)\d{10}$/;
    return MOBILE_REGEXP.test(no);
  },
/**
   * 身份证号码校验，并获取生日、性别、年龄
   * @param code
   * @returns {{pass: boolean, msg: string, birthDay: number, gender: null, age: null, ageUnit: string}}
   * @constructor
   */
  IdCodeValid(code) {
    if (code) {
      // 身份证号合法性验证
      // 支持15位和18位身份证号
      // 支持地址编码、出生日期、校验位验证
      const city = {
        11: '北京',
        12: '天津',
        13: '河北',
        14: '山西',
        15: '内蒙古',
        21: '辽宁',
        22: '吉林',
        23: '黑龙江 ',
        31: '上海',
        32: '江苏',
        33: '浙江',
        34: '安徽',
        35: '福建',
        36: '江西',
        37: '山东',
        41: '河南',
        42: '湖北 ',
        43: '湖南',
        44: '广东',
        45: '广西',
        46: '海南',
        50: '重庆',
        51: '四川',
        52: '贵州',
        53: '云南',
        54: '西藏 ',
        61: '陕西',
        62: '甘肃',
        63: '青海',
        64: '宁夏',
        65: '新疆',
        81: '香港',
        82: '澳门',
        83: '台湾',
        91: '国外 '
      };
      // 出生年月日校验   前正则限制起始年份为1900;
      const year = code.substr(6, 4); // 身份证年
      const month = code.substr(10, 2); // 身份证月
      const date = code.substr(12, 2); // 身份证日
      const birth = new Date(year + '-' + month + '-' + date);
      const time = Date.parse(year + '-' + month + '-' + date); // 身份证日期时间戳date
      const now_time = Date.parse(new Date().toDateString());
      const dates = (new Date(year, month, 0)).getDate(); // 身份证当月天数
      const gender = code.substr(16, 1);
      let row = {
        'pass': true,
        'msg': '验证成功',
        'birthDay': time,
        'gender': null,
        'age': null,
        'ageUnit': 'Y'
      };
      if (parseInt(gender % 2 + '', 0) === 1) {
        row.gender = '1';
      } else {
        row.gender = '2';
      }
      row.age = this.ages(birth.getFullYear(), birth.getMonth() + 1, birth.getDate()).age;
      row.ageUnit = this.ages(birth.getFullYear(), birth.getMonth() + 1, birth.getDate()).ageUnit;
      if (!code || !/^\d{6}(19|20)?\d{2}(0[1-9]|1[012])(0[1-9]|[12]\d|3[01])\d{3}(\d|[xX])$/.test(code)) {
        row = {
          'pass': false,
          'msg': '身份证号格式错误',
          'birthDay': null,
          'gender': null,
          'age': null,
          'ageUnit': 'Y'
        };
      } else if (!city[code.substr(0, 2)]) {
        row = {
          'pass': false,
          'msg': '身份证号地址编码错误',
          'birthDay': null,
          'gender': null,
          'age': null,
          'ageUnit': 'Y'
        };
      } else if (time > now_time || date > dates) {
        row = {
          'pass': false,
          'msg': '出生日期不合规',
          'birthDay': null,
          'gender': null,
          'age': null,
          'ageUnit': 'Y'
        }
      } else {
        // 18位身份证需要验证最后一位校验位
        if (code.length == 18) {
          code = code.split('');
          // ∑(ai×Wi)(mod 11)
          // 加权因子
          const factor = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
          // 校验位
          const parity = [1, 0, 'X', 9, 8, 7, 6, 5, 4, 3, 2];
          let sum = 0;
          let ai = 0;
          let wi = 0;
          for (let i = 0; i < 17; i++) {
            ai = code[i];
            wi = factor[i];
            sum += ai * wi;
          }
          if (parity[sum % 11] != code[17].toUpperCase()) {
            row = {
              'pass': false,
              'msg': '身份证号校验位错误',
              'birthDay': null,
              'gender': null,
              'age': null,
              'ageUnit': 'Y'
            };
          }
        }
      }
      return row;
    }
  }

}