import request from "../util/request";
import {baseURL,apiURL,cffpURL} from "../environments/environment";

export default {
	//查看token是否已经失效
	checkToken(){
		const params = {
			token:uni.getStorageSync('uni-token'),
			ticket:'uni-app'
		}
		return request(`${baseURL}/api/authorize/checkToken`, "POST", params)
	},
	// 获取token
	obtainToken(){
		const params = {
			ticket:'uni-app',
			loginId:null
		}
		let h5userId = uni.getStorageSync('cffp_userId');
		if (h5userId) {
			params.loginId = h5userId;
		}
		return request(`${baseURL}/api/authorize/obtainToken`, "POST", params)
	},
	//获取验证码
	verificationCode(params){
		return request(`${baseURL}/api/verificationCode`, "POST", params)
	},
	//登录接口
	loginVerification(params){
		return request(`${cffpURL}/user/loginVerification`, "POST", params)
	},
	//注册接口
	register(params){
		return request(`${cffpURL}/user/register`, "POST", params)
	},
	//重置密码
	resetPassword(params){
		return request(`${cffpURL}/user/resetPassword`, "POST", params)
	},
	// 课程查询列表接口
	courseList(params){
		return request(`${cffpURL}/course/list`,"POST",params)
	},
	// 讲师信息查询
	lecturerQuery(params){
		return request(`${apiURL}/college/lecturerQuery`, "POST", params)
	},
	//账户信息获取
	queryAreaCenterInfo(params){
		return request(`${cffpURL}/areaCenter/queryAreaCenterInfo`, "POST", params)
	},
	//公告列表
	announcementQuery(params){
		return request(`${apiURL}/market/announcementQuery`, "POST", params)
	},
	//消息列表
	querySystemMessage(params){
		return request(`${apiURL}/systemMessage/querySystemMessage`, "POST", params)
	},
	//清除站内消息
	oneKeyRead(params){
		return request(`${apiURL}/systemMessage/oneKeyRead`, "POST", params)
	},
	//消息详情&单个阅读
	querySystemMessageDetail(params){
		return request(`${apiURL}/systemMessage/querySystemMessageDetail`, "POST", params)
	},
	// 学习认证列表
	querySignupList(params){
		return request(`${cffpURL}/certificate/querySignupList`, "POST", params)
	},
	// 个人认证列表
	userCertificateList(params){
		return request(`${cffpURL}/certificate/userCertificateList`, "POST", params)
	},
	// 认证详情
	queryCertificateInfo(params){
		return request(`${cffpURL}/certificate/queryCertificateInfo`, "POST", params)
	},
	// 课程详情
	courseDetail(params){
		return request(`${cffpURL}/course/detail`, "POST", params)
	},
	// 相关课程黎贝澳查询
	relatedCoursesList(params){
		return request(`${cffpURL}/course/relatedCoursesList`, "POST", params)
	},
	//邀请加盟与申请加盟保存接口
	saveApplyInfo(params){
		return request(`${cffpURL}/partner/saveApplyInfo`, "POST", params)
	},
	// 查询所属组织List
	queryOrgList(params){
		return request(`${cffpURL}/orgInfo/queryOrgList`, "POST", params)
	},
	//学习认证列表
	queryCertificateList(params){
		return request(`${cffpURL}/certificate/queryCertificateList`, "POST", params)
	},
	//学习认证结果
	userCertificateResult(params){
		return request(`${cffpURL}/certificate/userCertificateList`, "POST", params)
	},
	// 我的学习,学习记录
	userStudyList(params){
		return request(`${cffpURL}/study/userStudyList`, "POST", params)
	},
	// 我的分享
	userShareQuery(params){
		return request(`${cffpURL}/share/userShareQuery`, "POST", params)
	},
	// 订单详情
	userCourseInfo(params){
		return request(`${cffpURL}/course/userCourseInfo`, "POST", params)
	},
	//我的积分查询接口
	findByUserIdForFortuneStatistic(params){
		return request(`${apiURL}/fortune/findByUserIdForFortuneStatistic`, "POST", params)
	},
	//我的积分明细
	findForExchangeStatisticDtl(params){
		return request(`${apiURL}/fortune/findForExchangeStatisticDtl`, "POST", params)
	},
	//分类查询
	dropOptionsQuery(params){
		return request(`${apiURL}/metadata/dropOptionsQuery`, "POST", params)
	},
	// 销售课程统计
	userCourseCount(params){
		return request(`${cffpURL}/course/userCourseCount`, "POST", params)
	},
	// 销售课程列表查询
	userCourseList(params){
		return request(`${cffpURL}/course/userCourseList`, "POST", params)
	},
	// 分享课程列表查询
	userShareCourseList(params){
		return request(`${cffpURL}/course/userShareCourseList`, "POST", params)
	},
	//积分兑换查询
	queryByUserIdFortuneStatistic(params){
		return request(`${apiURL}/fortune/queryByUserIdFortuneStatistic`, "POST", params)
	},
	//积分兑换记录查询
	findByUserIdForWithdralHis(params){
		return request(`${apiURL}/fortune/findByUserIdForWithdralHis`, "POST", params)
	},
	//提现明细接口
	findByUserIdForWithdralDtl(params){
		return request(`${apiURL}/fortune/findByUserIdForWithdralDtl`, "POST", params)
	},
	// 我的售后
	userAfterSales(params){
		return request(`${cffpURL}/course/userAfterSales`, "POST", params)
	},
	// 售后详情
	userAfterSalesDtl(params){
		return request(`${cffpURL}/course/userAfterSalesDtl`, "POST", params)
	},
	// 个人信息查询
	queryInfo(params){
		return request(`${cffpURL}/user/queryInfo`, "POST", params)
	},
	// 微信支付
	wxAppPay(params){
		return request(`${apiURL}/pay/wxAppPay`, "POST", params)
	},
	// 订单保存
	saveOrder(params){
		return request(`${cffpURL}/order/saveOrder`, "POST", params)
	},
	//去提现接口
	goFortuneWithdrawal(params){
		return request(`${apiURL}/fortune/goFortuneWithdrawal`, "POST", params)
	},
	// 支付宝支付
	aliAppPay(params){
		return request(`${apiURL}/aliPay/aliAppPay`, "POST", params)
	},
	// 分享链接列表
	userShareLinkList(params){
		return request(`${cffpURL}/share/userShareLinkList`, "POST", params)
	},
	// 分享阅读列表
	userShareReadList(params){
		return request(`${cffpURL}/share/userShareReadList`, "POST", params)
	},
	// 分享购买列表
	userShareBuyList(params){
		return request(`${cffpURL}/share/userShareBuyList`, "POST", params)
	},
	// 我的分享统计
	userShareCount(params){
		return request(`${cffpURL}/share/userShareCount`, "POST", params)
	},
	// 退课明细
	userRefundCourseDtl(params){
		return request(`${cffpURL}/course/userRefundCourseDtl`, "POST", params)
	},
	//查询证件类型
	erpInitialize(params){
		return request(`${apiURL}/erp/erpInitialize`, "POST", params)
	},
	//获取职业类别
	occupationQry(params){
		return request(`${apiURL}/metadata/occupationQry`, "POST", params)
	},
	// 邀请列表查询
	queryInviteList(params){
		return request(`${cffpURL}/partner/queryInviteList`, "POST", params)
	},
	// 视频播放轨迹保存
	saveVideoPlayback(params){
		return request(`${apiURL}/videoPlay/saveVideoPlayback`, "POST", params)
	},
	// 查询视频播放最新记录
	findVideoPlayback(params){
		return request(`${apiURL}/videoPlay/findVideoPlayback`, "POST", params)
	},
	// 教育等级查询
	educationLevelQuery() {
		return request(`${apiURL}/metadata/educationLevelQuery`, "GET")
	},
	// 退课列表
	queryDropCourseList(params){
		return request(`${cffpURL}/course/queryDropCourseList`, "POST", params)
	},
	// 我的团队
	queryMyTeamInfo(params){
		return request(`${cffpURL}/orgInfo/queryMyTeamInfo`, "POST", params)
	},
	// 我的团队展开
	queryTeamDetail(params){
		return request(`${cffpURL}/orgInfo/teamDetail`, "POST", params)
	},
	// 团队业绩
	queryTeamAchievement(params){
		return request(`${cffpURL}/orgInfo/queryTeamAchievement`, "POST", params)
	},
	// 学习统计
	userStudyCount(params){
		return request(`${cffpURL}/study/userStudyCount`, "POST", params)
	},
	//  我的团队展开LIST
	teamDetail(params){
		return request(`${cffpURL}/orgInfo/teamDetail`, "POST", params)
	},
	// 课程包学习进度明细
	userCoursePackBar(params){
		return request(`${cffpURL}/study/userCoursePackBar`, "POST", params)
	},
	// 学习明细
	userStudyTime(params){
		return request(`${cffpURL}/study/userStudyTime`, "POST", params)
	},
	//合同声明
	listQuery(params){
		return request(`${cffpURL}/contract/listQuery`, "POST", params)
	},
	// 个人信息修改
	updateinfo(params){
		return request(`${cffpURL}/user/update`, "POST", params)
	},
	// 上传接口
	uploadFile(params){
		return request(`${cffpURL}/api/file/upload`, "POST", params)
	},
	// 认证--查询个人信息
	querySignUpInfo(params){
		return request(`${cffpURL}/user/querySignUpInfo`, "POST", params)
	},
	// 认证--上传就个人信息
	uploadSignUpUserInfo(params){
		return request(`${cffpURL}/user/uploadSignUpUserInfo`, "POST", params)
	},
	//查询申请加盟信息
	queryById(params){
		return request(`${cffpURL}/partner/queryById`, "POST",params)
	},
	//支付宝去提现
	aliWithdrawal(params){
		return request(`${apiURL}/aliPay/aliWithdrawal`, "POST", params)
	},
	//微信去提现
	wxWithdrawal(params){
		return request(`${apiURL}/pay/wxWithdrawal`, "POST", params)
	},
	//保存base64电子签名
	saveDigitalSignatures(params){
		return request(`${cffpURL}/partner/saveDigitalSignatures`, "POST", params)
	},
	// 退款
	unifiedRefund(params){
		return request(`${apiURL}/pay/unifiedRefund`, "POST", params)
	},
	//判断是否授权
	isAuth(params){
		return request(`${apiURL}/aliPay/isAuth`, "POST", params)
	},
	// 账号注销
	cancellation(params){
		return request(`${apiURL}/cffp/user/cancellation`, "POST", params)
	},
	// 用户分享
	userShare(params){
		return request(`${apiURL}/cffp/share/userShare`, "POST", params)
	},
	// 用户阅读
	userRead(params){
		return request(`${apiURL}/cffp/share/userRead`, "POST", params)
	},
	//H5 分享
	Wxshare(params){
		return request(`${apiURL}/wxConfig`, "POST", params)
	},
	//支付宝网页支付
	aliWapPay(params){
		return request(`${apiURL}/aliPay/aliWapPay`, "POST", params)
	},
	//统一支付接口
	unifiedPay(params){
		return request(`${apiURL}/pay/unifiedPay`, "POST", params)
	},
	// 保单单利复利计算
	irrAndSimpleCalcute(params) {
		return request(`${baseURL}/api/sfp/calcuteUtil/irrAndSimpleCalcute`, "POST", params)
	},
	// 获取unionId
	getWxUserInfo(params){
		return request(`${baseURL}/api/getWxUserInfo`, "POST", params)
	},
	//增额寿和年金(单利复利)计算结果查询接口
	queryIrrAndSimple(params){
		return request(`${baseURL}/api/sfp/calcuteUtil/queryIrrAndSimple`, "POST", params)
	},
	//获取城市
	provCityQry(params){
		return request(`${baseURL}/api/metadata/provCityQry`, "POST", params)
	},
	
	//购房能力测算
	housePurchasePlanAnalysis(params){
		return request(`${baseURL}/api/sfp/calcuteUtil/housePurchasePlanAnalysis`, "POST", params)
	},
	
	// 各城市商品住宅销售价格查询接口
	queryCommercialHousingPrice(params){
		return request(`${baseURL}/api/sfp/calcuteConfig/queryCommercialHousingPrice`, "POST", params)
	},
	// 子女教育测算
	educationEstimate(params){
		return request(`${baseURL}/api/sfp/calcuteUtil/educationEstimate`, "POST", params)
	},
	//微信认证
	wxAuthorize(params){
		return request(`${baseURL}/api/pay/wxAuthorize`, "POST", params)
	},
	//验证验证码是否正确
	verification(params){
		return request(`${cffpURL}/user/verification`, "POST", params)
	}
}
