
import request from "./request";
import authorizeUtils from "./authorizeUtils";
import { apiURL } from "../environments/environment";
// 上传图片事件
export function CommonUpload(psrams) {
	let requestVO = psrams
	// @ts-ignore
	return new Promise((resolve, reject) => {
	    // #ifdef APP-PLUS
		  let imageCamera = uni.getStorageSync('imageCamera');
		  if(!imageCamera || imageCamera != '1'){
			 uni.showModal({
				title: '权限说明',
				content: '我们需要访问您的相机和相册，以便您拍摄或上传图片。',
				confirmText: '同意',
				cancelText: '拒绝',
				success: function (res) {
		  		  if (res.confirm) {
			 		uni.setStorageSync('imageCamera', '1');
					uni.chooseImage({
						count: 1, //默认9
						sizeType: ['original', 'compressed'], //可以指定是原图还是压缩图，默认二者都有
						sourceType: ['album','camera'], //从相册选择
						success: function(res) {
							uni.showLoading({title: '加载中', mask: true});
							uni.uploadFile({
								url: `${apiURL}/file/upload`, // 后端api接口
								filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
								name: 'file', //后端通过'file'获取上传的文件对象
								formData: { requestVO: JSON.stringify(requestVO)},//后台所需除图片外的参数可以写在这里面 ，单张多张都可
								header: {'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : ''},
								success: (res) => {
									resolve(JSON.parse(res.data));
									uni.hideLoading();
								},
								fail:(err) =>{
									uni.showModal({content:'上传失败', showCancel: false})
									uni.hideLoading();
								}
							});
						}
					});
				  }
				}
			})
		  }else{
			uni.chooseImage({
				count: 1, //默认9
				sizeType: ['original', 'compressed'], //可以指定是原图还是压缩图，默认二者都有
				sourceType: ['album','camera'], //从相册选择
				success: function(res) {
					uni.showLoading({title: '加载中', mask: true});
					uni.uploadFile({
						url: `${apiURL}/file/upload`, // 后端api接口
						filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
						name: 'file', //后端通过'file'获取上传的文件对象
						formData: { requestVO: JSON.stringify(requestVO)},//后台所需除图片外的参数可以写在这里面 ，单张多张都可
						header: {'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : ''},
						success: (res) => {
							resolve(JSON.parse(res.data));
							uni.hideLoading();
						},
						fail:(err) =>{
							uni.showModal({content:'上传失败', showCancel: false})
							uni.hideLoading();
						}
					});
				}
			});
		  }
		// #endif
		// #ifdef H5
		uni.chooseImage({
			count: 1, //默认9
			sizeType: ['original', 'compressed'], //可以指定是原图还是压缩图，默认二者都有
			sourceType: ['album','camera'], //从相册选择
			success: function(res) {
				uni.showLoading({title: '加载中', mask: true});
				uni.uploadFile({
					url: `${apiURL}/file/upload`, // 后端api接口
					filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
					name: 'file', //后端通过'file'获取上传的文件对象
					formData: { requestVO: JSON.stringify(requestVO)},//后台所需除图片外的参数可以写在这里面 ，单张多张都可
					header: {'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : ''},
					success: (res) => {
						resolve(JSON.parse(res.data));
						uni.hideLoading();
					},
					fail:(err) =>{
						uni.showModal({content:'上传失败', showCancel: false})
						uni.hideLoading();
					}
				});
			}
		});
		// #endif
	})
}

//图片放大
export function ckbigImg(params) {
	wx.previewImage({
		urls: [params], //需要预览的图片http链接列表，多张的时候，url直接写在后面就行了
		current: '', // 当前显示图片的http链接，默认是第一个
		success: function(res) {},
		fail: function(res) {},
		complete: function(res) {},
	})
}

// 这个方法用来上传文件
export function uploadFilepdf(params) {
	let requestVO = params
	// @ts-ignore
	return new Promise((resolve, reject) => {
		uni.chooseFile({
			count: 1, //默认100
			extension: ['.pdf', '.doc'],
			success: function(res) {
				  var str = res.tempFiles[0].name; //截取后4位
				    let a = str.substring(str.length - 3);
					if(a !== 'pdf') {
						uni.showToast({
							title: '上传文件格式不正确！',
							duration: 2000,
							icon: 'none'		
						});
						return
					}
			    var name = 	res.tempFiles[0].name
				uni.showLoading({
					title: '加载中',
					mask: true
				});
				uni.uploadFile({
					url: `${apiURL}/file/upload`, // 后端api接口
					filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
					name: 'file', //后端通过'file'获取上传的文件对象
					formData: {
						requestVO: JSON.stringify(requestVO)
					},
					header: {
						'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : ''
					},
					success: (res) => {
						let data = JSON.parse(res.data)
						if(data.success == true){
							data.name = name
							resolve(data)
						} else {
							uni.showToast({
								title: '上传失败',
								duration: 2000,
								icon: 'none'		
							});
						}
						uni.hideLoading();
					}
				});
			}
		});
	})
}