export default {
  mobileNoValid(no) {
    const MOBILE_REGEXP = /^(1)\d{10}$/;
    return MOBILE_REGEXP.test(no);
  },
  passwordValid(no) {
    const PASSWOED_REGEXP = /^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,12}$/;
    return PASSWOED_REGEXP.test(no);
  },
  getQueryString(name){
      const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
      const r = decodeURIComponent(window.location.search).substr(1).match(reg);
      if (r != null) {
        return r[2];
      }
      return null;
  },
  
  // 封装报错弹窗
  errorDialog(type,content,title=null){
  	// type 1 必填项校验 2 规则校验
  	uni.showModal({
  	  title: title ? title : (type===1 ? '必填项校验' : '规则校验'),
  	  content:content,
  	  showCancel:false,
  	  success: function (res) {
  			  if (res.confirm) {
  					  console.log('用户点击确定');
  			  } else if (res.cancel) {
  					  console.log('用户点击取消');
  			  }
  	  }
  	});
  },
}