import { defineConfig } from 'vite'
import { createVuePlugin } from 'vite-plugin-vue2'
import path from 'path'

export default defineConfig({
    // 关键修改：设置 base 路径，与 Nginx 配置匹配
    base: '/cffp/',

    plugins: [createVuePlugin()],

    resolve: {
        extensions: ['.vue', '.js', '.ts', '.json'],
        alias: {
            '@': path.resolve(__dirname),
            '@api': path.resolve(__dirname, 'api')
        }
    },

    // 开发服务器配置（可选）
    server: {
        port: 8080,
        proxy: {
            // 代理后端 API 请求，避免跨域问题
            '/cffpApi': {
                target: 'http://localhost:8080',
                changeOrigin: true,
                rewrite: (path) => path.replace(/^\/cffpApi/, '')
            }
        }
    },

    // 生产环境构建配置
    build: {
        outDir: 'dist', // 输出目录
        assetsDir: 'assets', // 静态资源目录
        rollupOptions: {
            output: {
                // 确保生成的资源路径正确
                assetFileNames: 'assets/[name].[hash].[ext]',
                chunkFileNames: 'assets/[name].[hash].js',
                entryFileNames: 'assets/[name].[hash].js'
            }
        }
    }
})
