import dayjs from 'dayjs';
export default{
	// 获取url的参数
	getQueryString(name){
	    const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
	    const r = decodeURIComponent(window.location.search).substr(1).match(reg);
	    if (r != null) {
	      return r[2];
	    }
	    return null;
	},
	// 数字千分位
	numberConverter(value){
	  if (!value) return 0
	  // 获取整数部分
	  const intPart = Math.trunc(value)
	  // 整数部分处理，增加,
	  const intPartFormat = intPart.toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,')
	  // 预定义小数部分
	  let floatPart = ''
	  // 将数值截取为小数部分和整数部分
	  const valueArray = value.toString().split('.')
	  if (valueArray.length === 2) { // 有小数部分
	    floatPart = valueArray[1].toString() // 取得小数部分
	    return intPartFormat + '.' + floatPart
	  }
	  return intPartFormat + floatPart	
	},
	// 秒转换成时分秒
	secondsTransferPipe(value:number){
		   const h = Math.floor(value / 3600) > 0 ? (Math.floor(value / 3600) <= 9 ? '0' + Math.floor(value / 3600) : Math.floor(value / 3600)): '00';
		  const m = Math.floor(value % 3600 / 60) > 0 ? (Math.floor(value % 3600 / 60)<=9 ? '0'+Math.floor(value % 3600 / 60):Math.floor(value % 3600 / 60)) : '00';
		  const s = Math.floor(value % 60) > 0 ? (Math.floor(value % 60) <=9 ? '0'+Math.floor(value % 60) : Math.floor(value % 60)) : '00';
		  return h + ':' + m + ':' + s;
	},
	// 日期格式化  这个方法会出现系统不同，时间处理不了的问题
	dateFormat(val:number,format='yyyy-MM-dd hh:mm:ss'){
		console.log('val',val);
		if(val){
			const date = new Date(val);
			const year = date.getFullYear();
			const month = (date.getMonth() + 1) <10 ? '0' + (date.getMonth() + 1) : (date.getMonth() + 1);
			const day = date.getDate() < 10 ? '0' + date.getDate() :  date.getDate();
			const hours = date.getHours() < 10 ? '0' + date.getHours() : date.getHours();
			const minutes = date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes();
			const seconds = date.getSeconds() < 10 ? '0' + date.getSeconds() : date.getSeconds();
			
			if(format === 'yyyy-MM-dd'){
				return year + '-' + month + '-' + day
			}else if(format === 'yyyy-MM-dd hh:mm:ss'){
				return year + '-' + month + '-' + day + ' ' + hours + ':' + minutes+ ':' + seconds
			}
			
		}else {
			return val;
		}
	},
	// 日期格式化  day.js
	dateFormat2(val: number | string, format = 'yyyy-MM-dd hh:mm:ss') {
	    if (!val) return val;
	    
	    try {
	        const date = dayjs(val);
	        if (!date.isValid()) return val;
	        
	        if (format === 'yyyy-MM-dd') {
	            return date.format('YYYY-MM-DD');
	        } else {
	            return date.format('YYYY-MM-DD HH:mm:ss');
	        }
	    } catch (e) {
	        console.error('Date format error:', e);
	        return val;
	    }
	},
	// 分别获取年、月
	 getDateParts() {
	   const d = dayjs();
	   return {
	     year: d.year(),
	     month: d.month() + 1, // 月份从0开始，所以要+1
	     monthPadded: d.format('MM'), // 补零的月份（如 "01"）
	     day: d.date(), // 获取日期（1-31）
	     dayPadded: d.format('DD'), // 补零的日期（如 "01"）
	     fullDate: d.format('YYYY-MM-DD'), // 完整日期格式（如 "2023-05-15"）
	     fullDateCN: d.format('YYYY年MM月DD日') // 中文格式日期（如 "2023年05月15日"）
	   };
	 },
	
	  // 获取本月范围
	    getCurrentMonthRange() {
	      const start = dayjs().startOf('month').format('YYYY-MM-DD');
	      const end = dayjs().format('YYYY-MM-DD');
	      return [start, end];
	    },
	    
	    // 获取最近N天的范围
	    getRecentDaysRange(days) {
	      const end = dayjs().format('YYYY-MM-DD');
	      const start = dayjs().subtract(days - 1, 'day').format('YYYY-MM-DD');
	      return [start, end];
	    },
		// 获取指定年月的月初和月末日期
		  getMonthRange(year, month) {
		    try {
		      // 验证年和月是否有效
		      if (isNaN(year) || isNaN(month) || month < 1 || month > 12) {
		        throw new Error('Invalid year or month');
		      }
		      
		      const date = dayjs(`${year}-${month}-01`);
		      if (!date.isValid()) {
		        throw new Error('Invalid date');
		      }
		      
		      return {
		        start: date.startOf('month').format('YYYY-MM-DD'),
		        end: date.endOf('month').format('YYYY-MM-DD')
		      };
		    } catch (error) {
		      console.error('Error getting month range:', error);
		      return {
		        start: '',
		        end: ''
		      };
		    }
		  },
	// 年龄是否大于18
	 isAdult(birthDateString) {
		 if(!birthDateString) return 
	  // 拆分日期字符串
	  const parts = birthDateString.split('-');
	  if (parts.length !== 3) return false;
	
	  const year = parseInt(parts[0], 10);
	  const month = parseInt(parts[1], 10);
	  const day = parseInt(parts[2], 10);
	
	  // 检查年月日是否为有效数字
	  if (isNaN(year) || isNaN(month) || isNaN(day)) return false;
	
	  // 创建日期对象（月份从0开始）
	  const birthDate = new Date(year, month - 1, day);
	
	  // 验证日期有效性
	  if (
	    birthDate.getMonth() + 1 !== month ||
	    birthDate.getDate() !== day
	  ) {
	    return false;
	  }
	
	  const currentDate = new Date();
	
	  // 检查出生日期是否在当前日期之后
	  if (birthDate > currentDate) {
	    return false;
	  }
	
	  // 计算18年后的日期
	  const eighteenYearsLater = new Date(birthDate);
	  eighteenYearsLater.setFullYear(eighteenYearsLater.getFullYear() + 18);
	
	  // 判断是否已满18岁
	  return eighteenYearsLater <= currentDate;
	},
	// 防抖函数
	debounce(fn, delay = 200) {
	    let timer = null;
	    return function (...args) {
	        if (timer) clearTimeout(timer); // 清除之前的计时器
	        timer = setTimeout(() => {
	            fn.apply(this, args); // 延迟执行
	        }, delay);
	    };
	},
	/**
	 * 安全可靠的运行环境判断
	 * @returns {'app' | 'wechat-h5' | 'wechat-mp' | 'wechat-work' | 'browser' | 'unknown'}
	 */
	getRuntimeEnv() {
	  try {
	    // UniApp 环境判断
	    if (typeof uni !== 'undefined' && uni.getEnv) {
	      const uniEnv = uni.getEnv();
	      if (uniEnv === 'app-plus') return 'app';
	      if (uniEnv === 'mp-weixin') return 'wechat-mp';
	    }
	
	    // H5 环境判断
	    if (
	      typeof window !== 'undefined' &&
	      window.navigator &&
	      window.navigator.userAgent
	    ) {
	      const ua = window.navigator.userAgent.toLowerCase();
	      if (/micromessenger/i.test(ua)) {
	        return /wxwork/i.test(ua) ? 'wechat-work' : 'wechat-h5';
	      }
	      return 'browser';
	    }
	
	    return 'unknown';
	  } catch (e) {
	    console.warn('环境判断失败:', e);
	    return 'unknown';
	  }
	},
	/**
	 * 判断当前运行环境
	 * @returns {Object} 包含环境信息的对象
	 */
	 getRuntimeEnv2() {
	  // 获取uni-app系统信息
	  const systemInfo = uni.getSystemInfoSync()
	  
	  // 判断平台类型
	  const isH5 = systemInfo.platform === 'h5'
	  const isApp = systemInfo.platform === 'android' || systemInfo.platform === 'ios'
	  const isMP = systemInfo.platform === 'mp-weixin' // 微信小程序
	  
	  // 判断设备类型
	  let isMobile = false
	  let isTablet = false
	  let isDesktop = false
	  
	  // 在H5环境下需要额外判断
	  if (isH5) {
	    // 通过userAgent判断
	    const userAgent = navigator.userAgent.toLowerCase()
	    const isMobileUserAgent = /mobile|android|iphone|ipad|ipod/.test(userAgent)
	    
	    // 通过屏幕尺寸判断
	    const isSmallScreen = window.innerWidth < 768
	    
	    // 在开发环境下，如果浏览器开启了手机模拟器模式，也认为是手机
	    isMobile = isMobileUserAgent || isSmallScreen
	    
	    // 平板判断
	    isTablet = !isMobile && (systemInfo.windowWidth >= 768 && systemInfo.windowWidth < 992)
	    
	    // 桌面判断
	    isDesktop = !isMobile && !isTablet
		return
	  } else {
	    // 非H5环境使用uni-app提供的信息
	    isMobile = systemInfo.deviceType === 'phone'
	    isTablet = systemInfo.deviceType === 'pad'
	    isDesktop = false // 非H5环境下不会有桌面端
	  }
	  
	  return {
	    // 平台类型
	    platform: {
	      isH5,
	      isApp,
	      isMP,
	      isWeixin: isMP, // 微信小程序别名
	      isAndroid: systemInfo.platform === 'android',
	      isIOS: systemInfo.platform === 'ios',
	    },
	    
	    // 设备类型
	    device: {
	      isMobile,
	      isTablet,
	      isDesktop,
	      isIPhone: systemInfo.model && systemInfo.model.includes('iPhone'),
	      isIPad: systemInfo.model && systemInfo.model.includes('iPad'),
	    },
	    
	    // 原始系统信息
	    systemInfo,
	  }
	}
}