// vite.config.js
import { defineConfig } from 'vite';
import vue from '@vitejs/plugin-vue';
import path from 'path';

export default defineConfig({
    plugins: [
        vue({
            template: {
                compilerOptions: {
                    // 解决模板解析问题
                    isCustomElement: (tag) => tag.startsWith('uni-')
                }
            }
        })
    ],
    resolve: {
        alias: {
            '@': path.resolve(__dirname, './src'),
        }
    },
    css: {
        preprocessorOptions: {
            scss: {
                additionalData: `@import "@/styles/variables.scss";`
            },
            less: {
                math: 'always'
            }
        }
    },
    build: {
        commonjsOptions: {
            transformMixedEsModules: true // 解决 CommonJS/ESM 混合问题
        }
    }
});
