
import {interceptor} from "./interceptor";
// 全局请求封装
export default (url:string, method:any, params:any) => {
	interceptor();
	return new Promise((resolve, reject) => {
		uni.request({
			url: url,
			method: method,
			data: {
				...params
			},
			success(res) {
				resolve(res.data);
			},
			fail(err) {
				reject(err);
			},
			complete() {
				uni.hideLoading();
			}
		});
	});
};


