// vite.config.mjs（保持内容不变，仅改扩展名）
import { defineConfig } from 'vite';
import vue from '@vitejs/plugin-vue';
import path from 'path';

export default defineConfig({
    plugins: [
        vue({
            template: {
                compilerOptions: {
                    isCustomElement: (tag) => tag.startsWith('uni-')
                }
            }
        })
    ],
    resolve: {
        alias: {
            '@': path.resolve(__dirname, './src'),
        }
    },
    css: {
        preprocessorOptions: {
            scss: {
                additionalData: `@import "@/styles/variables.scss";`
            },
            less: {
                math: 'always'
            }
        }
    },
    build: {
        commonjsOptions: {
            transformMixedEsModules: true
        }
    }
});
