import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-renewal-reminder',
  templateUrl: './renewal-reminder.component.html',
  styleUrls: ['./renewal-reminder.component.scss']
})
export class RenewalReminderComponent implements OnInit {
  index:number = 1;
  practitionerId:number;
  lists:Array<any>;
  selectTab(i){
    this.index = i;
  }
  constructor(private myService:MyService) { }

  ngOnInit() {
    this.practitionerId = localStorage.getItem('lifeCustomerInfo')?JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']:null;
  }

  queryNoticeList(){
    this.myService.queryNoticeList({practitionerId:this.practitionerId,status:this.index}).subscribe(res=>{
      if(res['success']){
        this.lists = res['data']['list'];
      }
    })
  }

}
