import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { LifeCommonService } from 'src/app/common/life-common.service';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-renewal-reminder-detail',
  templateUrl: './renewal-reminder-detail.component.html',
  styleUrls: ['./renewal-reminder-detail.component.scss']
})
export class RenewalReminderDetailComponent implements OnInit {
  practitionerId: number;
	orderPayId:  number;//续交记录id
	noticeType:  number;//1-短信 2-微信 3-电话
	content:  string; //通知内容
	remark:  string; //备注
  dialogDisabled:boolean;
  orderPayDetail:any;
  // 判断是经纪人1还是客户2看到的详情页面
  type:number = 1;
  isNeedAlert: boolean;
  dialogInfo: any;
  deviceType:number;
  shareSelect(type){
    this.noticeType = type;
    this.dialogDisabled = true;
    if(this.noticeType===2){
      this.wxShare()
    }
  }
  close = (e)=>{
    this.dialogDisabled = false;
  }
  constructor(private myService:MyService,private route:ActivatedRoute,private lifeCommonService:LifeCommonService) { }

  ngOnInit() {
    this.deviceType = this.lifeCommonService.checkDeviceType();
    this.orderPayId = this.route.snapshot.params['orderPayId'];
    this.type = this.route.snapshot.data.type;
    this.queryNoticeDetail();
  }

  queryNoticeDetail(){
    this.myService.queryNoticeDetail({orderPayId:this.orderPayId}).subscribe(res=>{
      if(res['success']){
        this.orderPayDetail = res['data']['orderPayDetail'];
      }else{
        this.openPopInfo(res['message']);
      }
    })
  }

  addNotice(){
    this.myService.addNotice({practitionerId:this.practitionerId,orderPayId:this.orderPayId,noticeType:this.noticeType,content:this.content,remark:this.remark}).subscribe(res=>{
      this.openPopInfo(res['message']);
    })
  }

  wxShare(){
    this.lifeCommonService.wxShare('续保提醒','保险续保提醒',`${window.location.origin}/reminder_detail/${this.orderPayId}`,'');
  }

  // 打开弹窗
  openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }
  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }

}
