import {Component, OnInit} from '@angular/core';
import {MyService} from '../my.service';
import { Router,ActivatedRoute } from "@angular/router";
import { ToastService } from 'ng-zorro-antd-mobile';

@Component({
  selector: 'ydlife-product-data',
  templateUrl: './product-data.component.html',
  styleUrls: ['./product-data.component.scss']
})
export class ProductDataComponent implements OnInit {
  productDataMenuLists: Array<any>;
  productId:any;
  planId:any;
  posterUrl:any;
  posterInfo:any;
  sellingPointDescList:Array<any>;
  isActive:any;
  constructor(private router: Router,private myService:MyService,private activatedRoute: ActivatedRoute,private _toast: ToastService) {
  }

  ngOnInit() {
    this.productId = this.activatedRoute.snapshot.paramMap.get('id');
    this.planId = this.activatedRoute.snapshot.queryParams.planId?this.activatedRoute.snapshot.queryParams.planId:null;
    this.queryProductFile();
  }

  queryProductFile(){
    this.myService.queryProductFile({productId:this.productId,planId:this.planId}).subscribe((res)=>{
      if(res['success']){
        this.productDataMenuLists = res['data']['categoryInfos'].filter((item)=>{
          return item.categoryId != 22;
        });
        this.posterInfo = res['data']['categoryInfos'].filter((item)=>{
          return item.categoryId == 22;
        });
        if(this.posterInfo[0] && this.posterInfo[0]['fileInfos']){
          this.posterUrl = this.posterInfo[0]['fileInfos']['0']['ossFilePath'];
        }
        this.sellingPointDescList = res['data']['sellingPointDescList'];
        this.isActive = res['data']['isActive'];
      }else{
        const toast = ToastService.show(`${res['message']}`, 0);
        setTimeout(() => {
          ToastService.hide();
        }, 3000);
      }
    })
  }

  jumpToDetail(urlItem){
    if(urlItem['categoryId'] != 35){
      this.router.navigate(['/filelist'],{queryParams:{planId:this.planId,productId:this.productId,categoryId:urlItem['categoryId']}})
    }else{
      if(this.isActive == 1){
        sessionStorage.setItem('commission',urlItem['fileInfos'][0]['description']);
      }
      if(this.isActive == null){
        const toast = ToastService.show('暂未配置公告佣金', 0);
        setTimeout(() => {
          ToastService.hide();
        }, 3000);
        return;
      }
      this.router.navigate(['/commission'],{queryParams:{productId:this.productId,planId:this.planId,isActive:this.isActive}});
    }
  }

  jumpToMaterial(){
    this.router.navigate([`/material/${this.posterInfo[0]['fileInfos']['0']['itemId']}`], 
    { queryParams: 
      { itemType: this.posterInfo[0]['fileInfos']['0']['itemType'],
        posterType: this.posterInfo[0]['fileInfos']['0']['id']
      }
    });
  }
}
