import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DatePipe } from "@angular/common";
import { MyRoutingModule } from './my-routing.module';
import { MyCenterHomeComponent } from './my-center-home/my-center-home.component';
import { LifeCommonModule } from "../common/life-common.module";
import { MkMaterialComponent } from './mk-material/mk-material.component';
import { MkMaterialDetailComponent } from './mk-material-detail/mk-material-detail.component';
import { FileUploadComponent } from './file-upload/file-upload.component';
import { ImportantAnnouncementComponent } from './important-announcement/important-announcement.component';
import { SalesDetailComponent } from './sales-detail/sales-detail.component';
import { AnnouncementDetailComponent } from './announcement-detail/announcement-detail.component';
import { MyBusinessComponent } from './my-business/my-business.component';
import { MyBusinessDetailComponent } from './my-business-detail/my-business-detail.component';
import { PickerComponent } from '../common/picker/picker.component';
import { MyToastComponent } from '../common/toast/toast.component';
import { SalesRankComponent } from './sales-rank/sales-rank.component';
import { TeamRankComponent } from './team-rank/team-rank.component';
import { RecruitingComponent } from './recruiting/recruiting.component';
import { RecruitingDetailComponent } from './recruiting-detail/recruiting-detail.component';
import { ThanksComponent } from './thanks/thanks.component';
import { MySettingComponent } from './my-setting/my-setting.component';
import { MySettingDetailComponent } from './my-setting-detail/my-setting-detail.component';
import { MyNewsComponent } from './my-news/my-news.component';
import { MyTargetComponent } from './my-target/my-target.component';
import { TeamPanelComponent } from './team-panel/team-panel.component';
import { SwitchNumberPipe } from '../common/pipe/switch-number.pipe';
import { SafeResourceUrlPipe } from '../common/pipe/safe-resource-url.pipe';
import { TeamSalesScoreComponent } from './team-sales-score/team-sales-score.component';
import { ScoreDetailsComponent } from './score-details/score-details.component';
import { BusinessCardComponent } from './business-card/business-card.component';
import { OrderDetailComponent } from './order-detail/order-detail.component';
import { SalaryComponent } from './salary/salary.component';
import { TodoListComponent } from './todo-list/todo-list.component';
import { AddTaskComponent } from './add-task/add-task.component';


import { NgZorroAntdMobileModule, ModalServiceComponent, ToastComponent } from 'ng-zorro-antd-mobile';
import {NgxEchartsModule} from 'ngx-echarts';
import { MedicalServiceComponent } from './medical-service/medical-service.component';
import { InvitationComponent } from './application-process/invitation/invitation.component';
import { RegisterComponent } from './application-process/register/register.component';
import { EmployeeInfoComponent } from './application-process/employee-info/employee-info.component';
import { EmployeeBasicInfoComponent } from './application-process/employee-basic-info/employee-basic-info.component';
import { WorkExperienceComponent } from './application-process/work-experience/work-experience.component';
import { PersonalPhotosComponent } from './application-process/personal-photos/personal-photos.component';
import { EmployeeIdCardComponent } from './application-process/employee-id-card/employee-id-card.component';
import { EmployeeEducationComponent } from './application-process/employee-education/employee-education.component';
import { PersonalStatementComponent } from './application-process/personal-statement/personal-statement.component';
import { SignatureComponent } from './application-process/signature/signature.component';
import { EmployeeSubmitComponent } from './application-process/employee-submit/employee-submit.component';
import { BankCardComponent } from './application-process/bank-card/bank-card.component';
import { SignaturePadModule } from 'angular2-signaturepad';
import { MemberDetailComponent } from './member-detail/member-detail.component';
import { ApprovalListComponent } from './approval-list/approval-list.component';
import { ApprovalCommentsComponent } from './approval-comments/approval-comments.component';
import { ApprovalResultListComponent } from './approval-result-list/approval-result-list.component';
import { MyApplicationComponent } from './my-application/my-application.component';
import { SuggestionComponent } from './suggestion/suggestion.component';
import { EmployeeSalaryComponent } from './application-process/employee-salary/employee-salary.component';
import { HistoricalRankComponent } from './historical-rank/historical-rank.component';
import { TeamAreaPanelComponent } from './team-area-panel/team-area-panel.component';
import { ArticleComponent } from './article/article.component';
import { ArticleDetailComponent } from './article-detail/article-detail.component';
//富文本编辑器
import { UEditorModule } from 'ngx-ueditor';
import { ArticleReadComponent } from './article-read/article-read.component';
import { SalaryDetailComponent } from './salary-detail/salary-detail.component';
import { SalaryFirstYearComponent } from './salary-first-year/salary-first-year.component';
import { DetailModalComponent } from '../common/detail-modal/detail-modal.component';
import { ProductComponent } from './product/product.component';
import { ProductDataComponent } from './product-data/product-data.component';
import { CommissionComponent } from './commission/commission.component';
import { FileListComponent } from './file-list/file-list.component';
import { MyCustomerComponent } from './my-customer/my-customer.component';
import { CustomerRelationComponent } from './customer-relation/customer-relation.component';
import { MyCustomerPolicyComponent } from './my-customer-policy/my-customer-policy.component';
import { UnderwritingKnowledgeComponent } from './underwriting-knowledge/underwriting-knowledge.component';
import { MyQuestionComponent } from './my-question/my-question.component';
import { AskComponent } from './ask/ask.component';
import { MenuItemComponent } from './menu-item/menu-item.component';
import { MemberListComponent } from './member-list/member-list.component';
import { ENoticeComponent } from './e-notice/e-notice.component';
import { ENoticeSignComponent } from './e-notice-sign/e-notice-sign.component';
import { RenewalReminderComponent } from './renewal-reminder/renewal-reminder.component';
import { RenewalReminderDetailComponent } from './renewal-reminder-detail/renewal-reminder-detail.component';
import { JointSalesComponent } from './joint-sales/joint-sales.component';
import { JointSaleDetailComponent } from './joint-sale-detail/joint-sale-detail.component';
import { IntegrationComponent } from './integration/integration.component';
import { IntegrationDetailComponent } from './integration-detail/integration-detail.component';
import { IntegrationRuleComponent } from './integration-rule/integration-rule.component';
import { VideoComponent } from '../common/video/video.component';
import { QrcodeUploadComponent } from './application-process/qrcode-upload/qrcode-upload.component';
import { NewsDetailComponent } from './news-detail/news-detail.component';
import { MoreFeaturesComponent } from './more-features/more-features.component';
import { MineComponent } from './mine/mine.component';
import { YdCollegeComponent } from './yd-college/yd-college.component';
import { MyTrainingComponent } from './my-training/my-training.component';
import { TrainingRecordsComponent } from './training-records/training-records.component';
import { CourseDetailComponent } from './course-detail/course-detail.component';
import { SecondsTransferPipe } from '../seconds-transfer.pipe';
import { MyManagementComponent } from './my-management/my-management.component';

@NgModule({
  declarations: [MyCenterHomeComponent, MkMaterialComponent, MkMaterialDetailComponent, FileUploadComponent, ImportantAnnouncementComponent, SalesDetailComponent, AnnouncementDetailComponent, MyBusinessComponent, MyBusinessDetailComponent, PickerComponent, MyToastComponent, SalesRankComponent, TeamRankComponent, RecruitingComponent, RecruitingDetailComponent, ThanksComponent, MySettingComponent, MySettingDetailComponent, MyNewsComponent, MyTargetComponent, TeamPanelComponent, SwitchNumberPipe,SafeResourceUrlPipe, TeamSalesScoreComponent, ScoreDetailsComponent, BusinessCardComponent, OrderDetailComponent, SalaryComponent, TodoListComponent, AddTaskComponent, MedicalServiceComponent, InvitationComponent, RegisterComponent, EmployeeInfoComponent, EmployeeBasicInfoComponent, WorkExperienceComponent, PersonalPhotosComponent, EmployeeIdCardComponent, EmployeeEducationComponent, PersonalStatementComponent, SignatureComponent, EmployeeSubmitComponent, BankCardComponent, MemberDetailComponent, ApprovalListComponent, ApprovalCommentsComponent, ApprovalResultListComponent, MyApplicationComponent, SuggestionComponent, EmployeeSalaryComponent, HistoricalRankComponent, TeamAreaPanelComponent, ArticleComponent, ArticleDetailComponent, ArticleReadComponent,SalaryDetailComponent,SalaryFirstYearComponent,DetailModalComponent, ProductComponent, ProductDataComponent, CommissionComponent, FileListComponent,MyCustomerComponent, CustomerRelationComponent, MyCustomerPolicyComponent, UnderwritingKnowledgeComponent, MyQuestionComponent, AskComponent, MenuItemComponent, MemberListComponent, ENoticeComponent, ENoticeSignComponent, RenewalReminderComponent, RenewalReminderDetailComponent, JointSalesComponent, JointSaleDetailComponent, IntegrationComponent, IntegrationDetailComponent, IntegrationRuleComponent, VideoComponent, QrcodeUploadComponent, NewsDetailComponent, MoreFeaturesComponent, MineComponent, YdCollegeComponent, MyTrainingComponent, TrainingRecordsComponent, CourseDetailComponent,SecondsTransferPipe, MyManagementComponent],
  imports: [
    CommonModule,
    LifeCommonModule,
    MyRoutingModule,
    NgZorroAntdMobileModule,
    NgxEchartsModule,
    SignaturePadModule,
    UEditorModule
  ],
  entryComponents: [ModalServiceComponent, ToastComponent],
  providers: [
    DatePipe
  ]
})
export class MyModule {
}
