import { Component, OnInit, ViewChild, ElementRef, AfterViewInit } from '@angular/core';
import { Router } from '@angular/router';
import { LifeCommonService } from 'src/app/common/life-common.service';
import { MyService } from '../my.service';
declare var wx: any;
@Component({
  selector: 'ydlife-my-center-home',
  templateUrl: './my-center-home.component.html',
  styleUrls: ['./my-center-home.component.scss'],
})
export class MyCenterHomeComponent implements OnInit {
  messageUnreadCount:string;
  productInfo: any;
  inquiry: any;
  public announcementInfo: string;
  public searchText: string;
  public featureLists = [
    { key: '00', name: '产品库', icon: 'productLibary', link: '/product', isOpen: true },
    { key: '01', name: '计划书', icon: 'proposals', link: '', isOpen: false },
    { key: '02', name: '我的保单', icon: 'policyLists', link: '/salesDetail', isOpen: true },
    { key: '03', name: '续期管理', icon: 'renewalManagement', link: '/renewal_reminder', isOpen: true },
    { key: '04', name: '成交客户', icon: 'customers', link: '/customer', isOpen: true },
    { key: '05', name: '我的增员', icon: 'increaseStaff', link: '/recruiting', isOpen: true },
    { key: '06', name: '银盾学院', icon: 'ydCollege', link: '/ydCollege', isOpen: true },
    { key: '07', name: '更多功能', icon: 'more', link: '/moreFeatures', isOpen: true }
  ]
  public bannerLists = [];
  public hotProductLists = [];
  public onlineProductLists = [];
  state = {
    modal1: false,
  };
  onClose(key) {
    this.state[key] = false;
  }

  submit(value) {
    if (value.trim()) {
      this.router.navigate(['/product', { queryName: value.trim() }])
    }
  }
  
  querySystemMessage(){
    this.myService.querySystemMessage({practitionerId:localStorage.getItem('lifeCustomerInfo') ? JSON.parse(localStorage.getItem('lifeCustomerInfo')).practitionerId : null}).subscribe(res=>{
      if(res['success']){
        this.messageUnreadCount = res['data']['unReadcount'];
        if(Number(this.messageUnreadCount) > 99){
          this.messageUnreadCount = '99+';
        }
      }else{
        this.messageUnreadCount = null;
      }
    })
  }

  searchProduct() {
    // 查询互联网产品
    this.router.navigate(['/product', { queryTagId: 272 }])
  }

  clear(value) {
    this.searchText = '';
  }

  // 查询银盾公告
  announcementQuery() {
    this.myService.announcementQuery(null, 37).subscribe(res => {
      if (res['success']) {
        this.announcementInfo = res['data']['announcementInfoList'] ? res['data']['announcementInfoList'][0]['title'] : '银盾公告'
      }
    })
  }
  // 点击模块导航
  featureSelect(item) {
    if (item.isOpen) {
      this.router.navigate([item.link]);
    } else {
      this.state.modal1 = true;
    }
  }
  // 获取轮播图
  filePathQuery() {
    this.myService.filePath(6, 0, 7, null, null).subscribe(res => {
      if (res['success']) {
        this.bannerLists = res['data']['fileUploadItemList'] || [];
      }
    })
  }
  // 模糊查询产品
  queryproductlistbytag(tagId, dataName) {
    this.myService.queryproductlistbytag({ mdTagId: tagId }).subscribe(res => {
      if (res['success']) {
        this[dataName] = res['data']['plans']
      }
    })
  }

  // 点击产品进入详情页
  goProductDetail(product): void {
    if (product.isThirdpartyPurchase == 1) {
      if (product.thirdpartyPurchaseUrl) {
        window.location.href = product.thirdpartyPurchaseUrl;
      } else {
        alert('请配置跳转链接');
      }
    } else {
      this.productInfo = product;
      this.productInfo.type = 2;
      this.inquiry = {
        planId: this.productInfo.planId,
        adultCount: this.productInfo.adultCount,
        childCount: this.productInfo.childCount,
        eldCount: this.productInfo.eldCount,
        dayCount: this.productInfo.minDay
      };
      this.setInitDate();
      localStorage.setItem('inquiry', JSON.stringify(this.inquiry));
      if (this.productInfo.noPlanProduct === true) {
        window.location.href = `https://${window.location.host}/life/${this.productInfo.productId}`
      } else {
        if (this.productInfo.productCategoryId === 1 || this.productInfo.productCategoryId === 4) {
          window.location.href = `https://${window.location.host}/pdetail/${this.productInfo.planId}`
        } else if (this.productInfo.productCategoryId === 2) {
          window.location.href = `https://${window.location.host}/hProductDetail/${this.productInfo.planId}?type=7`
        } else if (this.productInfo.productCategoryId === 5) {
          window.location.href = `https://${window.location.host}/hProductDetail/${this.productInfo.planId}?type=9`
        } else {
          window.location.href = `https://${window.location.host}/life/${this.productInfo.productId}`
          this.router.navigate(['/pdetail', this.productInfo.planId]);
        }
      }
    }
  }

  // 根据开始时间设置结束时间,天数应减1，当日~当日是一天
  setInitDate() {
    this.productInfo.dayCount = this.lifeCommonService.yearDayCount(this.productInfo.dayCount, this.productInfo.insurerId == '5');
    this.lifeCommonService.setInitDate(this.productInfo.dayCount);
  }

  goBannerPro(destinationAddress) {
    if (destinationAddress) {
      window.open(destinationAddress);
    } else {
      return;
    }
  }
  constructor(private myService: MyService, private router: Router, private lifeCommonService: LifeCommonService) { }
  ngOnInit(): void {
    this.filePathQuery()
    // 查询互联网产品
    this.queryproductlistbytag(272, 'onlineProductLists');
    // 查询热销产品
    this.queryproductlistbytag(119, 'hotProductLists');
    // 查询最新一条公告
    this.announcementQuery();
    // 查询未读消息总数
    this.querySystemMessage();
  }

}



