import { Component, OnInit } from '@angular/core';
import { Router,ActivatedRoute } from "@angular/router";
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-commission',
  templateUrl: './commission.component.html',
  styleUrls: ['./commission.component.scss']
})
export class CommissionComponent implements OnInit {
  commission:any;
  productId:any;
  planId:any;
  isActive:any;
  settlementRuleType:any;
  commissionInfoList:Array<any>;
  constructor(private activatedRoute: ActivatedRoute,private myService:MyService) { }

  ngOnInit() {
    this.planId = this.activatedRoute.snapshot.queryParams.planId?this.activatedRoute.snapshot.queryParams.planId:null;
    this.productId = this.activatedRoute.snapshot.queryParams.productId?this.activatedRoute.snapshot.queryParams.productId:null;
    this.isActive = this.activatedRoute.snapshot.queryParams.isActive?this.activatedRoute.snapshot.queryParams.isActive:null;
    this.commission = sessionStorage.getItem('commission');
    if(this.isActive == 2){
      this.queryCommissionInfoByYdLife();
    }
    
  }

  queryCommissionInfoByYdLife(){    
    this.myService.queryCommissionInfoByYdLife({productId:this.productId,planId:this.planId}).subscribe((res)=>{
      console.log(res)
       if(res['success']){
        this.settlementRuleType = res['data']['settlementRuleType'];
        this.commissionInfoList = res['data']['commissionInfoList'];
       }else{
          alert(res['success'])
       }
    })
  }
}
