import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { MyService } from 'src/app/my/my.service';

@Component({
  selector: 'ydlife-video',
  templateUrl: './video.component.html',
  styleUrls: ['./video.component.scss']
})
export class VideoComponent implements OnInit {
  filePath:string;
  fileCategory:string;
  fileId:string;
  isVideo:boolean;
  constructor(private activatedRoute: ActivatedRoute, private myService: MyService) { }

  ngOnInit() {
   this.fileId = this.activatedRoute.snapshot.params.fileId;
   this.fileCategory = this.activatedRoute.snapshot.params.fileCategory;
   console.log(this.activatedRoute)
   this.filePathQuery(null,this.fileId,this.fileCategory)
  }


  filePathQuery(status, fileId,fileCategory='23') {
    this.myService.filePath('3', '0', fileCategory, 'yd_trainning_file_type', null, null, status, fileId).subscribe(res => {
      if(res['success']){
        const fileUploadItem = res['data']['fileUploadItemList'][0];
        this.isVideo = this.judgmentFile(fileUploadItem.filePath,'video');
        if(this.isVideo){
          this.filePath = fileUploadItem.filePath;
        }else{
          this.filePath = `assets/pdfjs/web/viewer.html?file=${fileUploadItem.filePath}&isneeddownload=${fileUploadItem.isDownload=='1'?'true':'false'}`
        }
       
      }
    })
  }

    // 判断是不是视频文件
    judgmentFile(picUrl,type='video') {
      let filename = picUrl; //文件路径地址
      let index1 = filename.lastIndexOf(".");
      let index2 = filename.length;
      let postf = filename.substring(index1, index2).toLowerCase(); //获取文bai件后缀名duzhi
      if(type==='video'){
        //判断文件后缀名是否等于视频文件的后缀名
        if (postf===".avi"||postf===".mp4"||postf===".rmvb"||postf===".mov") {
          return true
        }else{
          return false
        }
      }else if(type==='pdf'){
          //判断文件后缀名是否等于pdf
          if (postf===".pdf") {
            return true
          }else{
            return false
          }
      }
      
    }
  
  menuPrevent() {
    return false;
  }

}
