import { Component, OnInit, ViewChild, ElementRef, AfterViewInit } from '@angular/core';
import { MyService } from "../my.service";
import { Router } from "@angular/router";
import { LifeCommonService } from '../../common/life-common.service';

@Component({
  selector: 'ydlife-important-announcement',
  templateUrl: './important-announcement.component.html',
  styleUrls: ['./important-announcement.component.scss']
})
export class ImportantAnnouncementComponent implements OnInit, AfterViewInit {
  @ViewChild('hide') hide: ElementRef
  announcementLists: Array<any>;
  importantAnnouncementLists: Array<any>;
  selectedCategoryId: any;
  titleList: Array<any> = [];
  constructor(
    private myService: MyService,
    private router: Router,
    public lifeCommonService: LifeCommonService) {
  }

  ngOnInit() {
    this.dropOptionsQuery();
  }

  ngAfterViewInit() {
    setTimeout(() => {
      this.switchCategory(this.selectedCategoryId)
    }, 500);
  }

  // 获取所有的公告类型
  dropOptionsQuery() {
    this.myService.dropOptionsQuery({ code: 'yd_mkt_announcement_type' }).subscribe(res => {
      if (res['success']) {
        this.importantAnnouncementLists = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
        if (this.importantAnnouncementLists.length > 0) {
          this.selectedCategoryId = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'][0]['id'];
          this.announcementQuery(null, this.selectedCategoryId);
        }
      }
    })
  }

  announcementQuery(id, announcementType) {
    this.myService.announcementQuery(id, announcementType).subscribe(res => {
      if (res['success']) {
        this.announcementLists = res['data']['announcementInfoList'];
      }
    });
  }


  switchCategory(e) {
    this.selectedCategoryId = e;
    this.announcementQuery(null, this.selectedCategoryId);
  }

}
