import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from '../../common/life-common.service';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService } from '../my.service';
import { ModalService, ToastService } from 'ng-zorro-antd-mobile';

@Component({
  selector: 'ydlife-underwriting-knowledge',
  templateUrl: './underwriting-knowledge.component.html',
  styleUrls: ['./underwriting-knowledge.component.scss']
})
export class UnderwritingKnowledgeComponent implements OnInit {
  tagLists:Array<any>;
  tagId:any = null;
  insurerId:any;
  productId:any;
  List:Array<any>;
  tagName:string;
  showPage:any = 1;
  problem:string;
  isShowFilter:boolean = false;
  insurerToastFlag:boolean = false; 
  productToastFlag:boolean = false;
  insurerList:Array<any>;
  insurerListShow:Array<any>;
  productList:Array<any>;
  productListShow:Array<any>;
  insurerChName:string = '点击选择保险公司';
  productName:string = '点击选择产品';
  notViewCont:any;
  constructor(private _toast: ToastService,public lifeCommonService: LifeCommonService,
    private activatedRoute: ActivatedRoute,
    private router:Router,
    private myService:MyService) { }

  ngOnInit() {
    this.lifeCommonService.setTitle('投核保问题');
    this.tagViewQuery();
    this.searchList(this.tagId);
    this.getNotViewCont();
  }

  tagViewQuery(){
    this.myService.tagViewQuery({"isActive":1,"tagViewType":"343","tagLevel":1}).subscribe((res)=>{
        if(res['success']){
          this.tagLists = res['data']['tagViewQueryInfos'];
        }
    })
  }

  searchList(tagId=null){
    const param = {
      insurerId:this.insurerId,
      productId:this.productId,
      isActive:1,
      mdTagId:tagId,
      problem:this.problem,
      warehousing:1
    }
    this.myService.underwritingProblemQuery(param).subscribe((res)=>{
      if(res['success']){
        this.List = res['data']['problemItems'];
      }
    })
  }
  
  changeTag(tagId,tagName){
    this.tagId = tagId;
    this.tagName = tagName;
    this.problem = this.insurerId = this.productId = null;
    this.insurerChName = '点击选择保险公司';
    this.productName = '点击选择产品';
    this.searchList(this.tagId);
  }

  erpInitialize(){
    this.myService.erpInitialize().subscribe((res)=>{
      if(res['success']){
        this.insurerList = res['data']['insurerItems'];
      }
    })
  }

   //产品列表
   productQry(insurerId) {
    this.myService.productQry({insurerId:insurerId}).subscribe(res => {
      this.productList = res["data"].productInfoList;
    });
  }

  //选择保险公司
  selectInsurer(insurerId,insurerChName){
    this.insurerId = insurerId;
    if(insurerId == null){
      this.productName = '点击选择产品';
    }
    this.insurerChName = insurerChName;
    this.tagId = this.problem =  this.productId = null;
    this.searchList(null);
    this.isShowFilter = false;
    this.insurerToastFlag = false;
  }

  //选择产品
  selectProduct(productId,productName){
    this.productId = productId;
    this.tagId = this.problem =  null;
    this.productName = productName;
    this.searchList(null);
    this.isShowFilter = false;
    this.productToastFlag = false;
  }
  
  change(event,type){
    if(type== 1){
      this.insurerListShow = this.insurerList.filter((item)=>{
        if(item.insurerChName){
          return item.insurerChName.indexOf(event) !==-1;
        }
      })
    }
    if(type== 2){
      this.productListShow = this.productList.filter((item)=>{
        if(item.productName){
          return item.productName.indexOf(event) !==-1;
        }
      })
    }
    
  }

  //点击我的问题头部&底部不显示，list更新
  clickMyQues(){
    this.router.navigate([`/my_question`]);
  }

  //获取经纪人未读信息
  getNotViewCont(){
    const param = {
      questioner:JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'],
      isActive:1,
    }
    this.myService.underwritingProblemQuery(param).subscribe((res)=>{
      if(res['success']){
        this.notViewCont = res['data']['notViewCont'];
      }
    })
  }
}
