import { Component, OnInit } from '@angular/core';
import { MyService } from '../../my/my.service';
import { LifeCommonService } from '../../common/life-common.service';
import { Router,ActivatedRoute } from '@angular/router';
import { parse } from 'querystring';

@Component({
  selector: 'ydlife-article',
  templateUrl: './article.component.html',
  styleUrls: ['./article.component.scss']
})
export class ArticleComponent implements OnInit {
  titleList:Array<any>;
  mdDropOptionId:number = null;
  paginationInfo:any;
  articleList:Array<any>;
  totalPage:number;
  constructor(private myService:MyService,public lifeCommonService:LifeCommonService,private router:Router) {
    this.paginationInfo = {
      pageNum: 1,
      pageSize: 5
    }
  }

  ngOnInit() {
    this.dropOptionsQuery();
  }

  dropOptionsQuery() {
    this.myService.dropOptionsQuery({ code: "practitioner_sharing_file_type" })
      .subscribe((res) => {
        if (res["success"]) {
          this.titleList =res["data"]["dropMasterInfoList"][0]["dropOptionsInfoList"];
          this.mdDropOptionId = this.titleList[0]['id'];
          this.practitionerFileSharingList(null);
        }
      });
  }

  selectTab(id) {
    this.mdDropOptionId = id;
    this.paginationInfo = {
      pageNum: 1,
      pageSize: 5
    }
    this.practitionerFileSharingList(null);
  }

  //文章查询列表
  practitionerFileSharingList(flag){
    const param = {
      mdDropOptionId:this.mdDropOptionId,
      practitionerFileShares:this.paginationInfo
    }
    this.myService.practitionerFileSharingList(param).subscribe((res)=>{
      if(res['success']){
        if(flag == null){
          this.articleList = res['data']['practitionerFileShares']['list'];
        }else{
          this.articleList = this.articleList.concat(res['data']['practitionerFileShares']['list'])
        }
        this.paginationInfo.pageNum = res['data']['practitionerFileShares']['pageNum'];//当前页
        this.totalPage = res['data']['practitionerFileShares']['pages'];//总页数
      }else{

      }
    })
  }

  lookMore(){
    this.paginationInfo.pageNum ++;
    this.practitionerFileSharingList('flag');
  }

  //设置缓存并跳转到文章详情
  articleDetail(articleItem){
    this.router.navigate(['/articleDetail',articleItem.id]);
  }

}
