import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from "@angular/router";
@Component({
  selector: 'ydlife-sales-rank',
  templateUrl: './sales-rank.component.html',
  styleUrls: ['./sales-rank.component.scss']
})
export class SalesRankComponent implements OnInit {
  performanceList: Array<any>;
  dateType: any;
  lineType: any;
  allPerformanceInfo: any;
  list: Array<any>;
  performanceListShow: Array<any>;
  rankType: any;
  searchList: Array<any>;
  constructor(private activatedRoute: ActivatedRoute) {
    this.performanceList = [
      { type: 'month', name: '本月' },
      { type: 'year', name: '本年' }
    ]
    this.list = [
      { type: 'online', name: '线上' },
      { type: 'underLine', name: '寿险' },

    ]
    this.searchList = [
      { type: 'fyp', name: 'FYP' },
      { type: 'fyc', name: 'FYC' },
      { type: 'count', name: '件数' }
    ]
  }

  ngOnInit() {
    this.dateType = this.activatedRoute.snapshot.queryParams.searchType;
    this.allPerformanceInfo = JSON.parse(sessionStorage.getItem('allPerformanceInfo'));
    this.selectRang(this.dateType, 'online', 'fyp')
    console.log(this.allPerformanceInfo)
  }

  selectRang(dateType, lineType, rankType) {
    this.dateType = dateType;
    this.lineType = lineType;
    this.rankType = rankType;
    if (lineType == 'online') {
      if (dateType == 'year') {
        if (rankType == 'fyp') {
          this.performanceListShow = this.allPerformanceInfo['thisYearInfo']['onlineInfo']['rankByFYP']['rank'];
        } else if (rankType == 'fyc') {
          this.performanceListShow = this.allPerformanceInfo['thisYearInfo']['onlineInfo']['rankByFYC']['rank'];
        } else if (rankType == 'count') {
          this.performanceListShow = this.allPerformanceInfo['thisYearInfo']['onlineInfo']['rankByCount']['rank'];
        } else {
          return;
        }
      }
      if (dateType == 'month') {
        if (rankType == 'fyp') {
          this.performanceListShow = this.allPerformanceInfo['thisMonthInfo']['onlineInfo']['rankByFYP']['rank'];
        } else if (rankType == 'fyc') {
          this.performanceListShow = this.allPerformanceInfo['thisMonthInfo']['onlineInfo']['rankByFYC']['rank'];
        } else if (rankType == 'count') {
          this.performanceListShow = this.allPerformanceInfo['thisMonthInfo']['onlineInfo']['rankByCount']['rank'];
        } else {
          return;
        }
        console.log(this.performanceListShow)

      }
    } else {
      this.performanceListShow = [];
    }
  }
}
