import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute } from "@angular/router";
import { BusinessQuery } from '../../domain/businessQuery';
import { LifeCommonService } from '../../common/life-common.service';
@Component({
  selector: 'ydlife-my-business-detail',
  templateUrl: './my-business-detail.component.html',
  styleUrls: ['./my-business-detail.component.scss']
})

export class MyBusinessDetailComponent implements OnInit {

  titleList: Array<any>;
  selectedId: number;
  surveyAnswersList: Array<any>;
  readonlyFlag: boolean = true;
  orderId: number;
  opportunityId: string;
  opportunitySurveyAnswersList: Array<any>;
  tagList: Array<any>;
  editBusiness: BusinessQuery = new BusinessQuery()
  businessStatusList: Array<any>;
  cityFlag: boolean;
  provinceList: Array<any>;
  provinces: Array<any>;
  //返回的标签列表
  opportunityCustomerTags: Array<any>;
  opportunityRecordInfos: Array<any>;
  //是否可以跳转预览方案
  isCompletedQuestionnaire: any;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  constructor(private activateRoute: ActivatedRoute, private myService: MyService,
    public lifeCommonService: LifeCommonService) {
    this.titleList = [
      { id: 1, name: '基本信息' },
      { id: 2, name: '咨询问卷' },
      { id: 4, name: '咨询预览' },
      { id: 3, name: '商机跟进' }

    ]
  }

  ngOnInit() {
    this.orderId = this.activateRoute.snapshot.queryParams['orderId'];
    this.opportunityId = this.activateRoute.snapshot.paramMap.get('id');
    this.tagQuery();
    this.selectTab(1);
    this.ownOpportunityDetailQuery();

    this.dropOptionsQuery();


  }

  editInfo() {
    this.readonlyFlag = false;
  }

  selectTab(id) {
    this.selectedId = id;
    if (id === 4) {
      if (this.isCompletedQuestionnaire == 1) {
        // window.location.href = `https://${window.location.host}/customizedPlanList/${this.opportunityId}?orderId=${this.orderId}`
        window.location.href = `https://${window.location.host}/customizedPlanList/2?orderId=8373`

      }
    }
  }

  ownOpportunityDetailQuery() {
    // const detailParam = {
    //   opportunityId: this.opportunityId,
    //   orderId: this.orderId,
    //   practitionerId: JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']
    // }
    const detailParam = {
      opportunityId: 2,
      orderId: 8373,
      practitionerId: 1
    }
    this.myService.ownOpportunityDetailQuery(detailParam).subscribe((res) => {
      if (res['success']) {
        this.opportunitySurveyAnswersList = res['data']['opportunityConsultationInfo']['opportunitySurveyAnswersList']
        this.editBusiness = res['data']['opportunityBasicInformationInfo'];
        this.opportunityCustomerTags = res['data']['opportunityBasicInformationInfo']['opportunityCustomerTags']
        this.opportunityRecordInfos = res['data']['opportunityRecordInfos'];
        this.isCompletedQuestionnaire = res['data']['opportunityConsultationInfo']['isCompletedQuestionnaire'];
        if (this.opportunityCustomerTags.length > 0) {
          for (let i = 0; i < this.opportunityCustomerTags.length; i++) {
            for (let j = 0; j < this.tagList.length; j++) {
              if (this.opportunityCustomerTags[i]['tagId'] == this.tagList[j]['id']) {
                this.tagList[j].selected = true;
              } else {
                this.tagList[j].selected = false;
              }
            }
          }
          console.log(this.tagList)
        }
      } else {
        this.opportunitySurveyAnswersList = [];
      }
    })
  }

  tagQuery() {
    this.myService.tagQuery({ tagType: 2, isActive: 1 }).subscribe((res) => {
      if (res['success']) {
        this.tagList = res['data']['tagVOs'];

      }
    })
  }

  //选标签
  selectTag(tagItem) {
    this.tagList.forEach((item, idx) => {
      if (tagItem.id == item.id) {
        this.tagList[idx].selected = !tagItem.selected
      }
    })
    this.editBusiness.opportunityCustomerTags = this.tagList.filter((item) => {
      return item.selected == true;
    })

  }

  //选男女
  selectedGender(e) {
    this.editBusiness.gender = e;
  }
  //商机状态
  dropOptionsQuery() {
    this.myService.dropOptionsQuery({ code: 'bizchance_promotion_action' }).subscribe((res) => {
      if (res['success']) {
        this.businessStatusList = res['data']['dropMasterInfoList']['0']['dropOptionsInfoList'];
      }
    })
  }

  saveInfo() {
    const newTag = this.editBusiness.opportunityCustomerTags.map((item) => {
      return {
        tagId: item.id ? item.id : item.tagId,
        tagName: item.tagName
      }
    })

    this.editBusiness = {
      ...this.editBusiness,
      opportunityCustomerTags: newTag
    }
    console.log(this.editBusiness)
    this.myService.ownOpportunityBasicInformationSave(this.editBusiness).subscribe((res) => {
      console.log(res)
      if (res['success']) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: '修改成功！',
          timeout: 3000,
          align: 'center'
        };
      }
    })
  }
}


