import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from '../../common/life-common.service';
import { ActivatedRoute,Router } from "@angular/router";


@Component({
  selector: 'ydlife-salary-detail',
  templateUrl: './salary-detail.component.html',
  styleUrls: ['./salary-detail.component.scss']
})
export class SalaryDetailComponent implements OnInit {
  monDtlPeriod:string;
  takFlag:boolean = false;
  toastShow:boolean;
  constructor(public lifeCommonService: LifeCommonService,
    private activatedRoute: ActivatedRoute,
    private router:Router) { }

  ngOnInit() {
    this.monDtlPeriod = this.activatedRoute.snapshot.queryParams.monDtlPeriod?this.activatedRoute.snapshot.queryParams.monDtlPeriod:null;
    this.lifeCommonService.setTitle(`${this.lifeCommonService.getDate(this.monDtlPeriod)}本期实发佣金`);
  }

  lookTak(){
    this.takFlag = true;
  }

  /**
   * 
   * @param type 
   * 1.首年度销售佣金
   * 2.续年度销售佣金
   * 3.首年度辅导奖金
   * 4.续年度辅导奖金
   * 5.特别管理奖金
   * 6.其他应税加扣款
   */
  jumpToFirstYearSales(type){
    this.router.navigate([`/salary_detail/${this.monDtlPeriod}`],{queryParams:{type:type}});

  }
}
