import { Component, OnInit } from "@angular/core";
import { AuthService } from '../../../auth/auth.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
import { MyService } from "../../my.service";
import { THIS_EXPR } from "@angular/compiler/src/output/output_ast";
@Component({
  selector: "ydlife-register",
  templateUrl: "./register.component.html",
  styleUrls: ["./register.component.scss"],
})
export class RegisterComponent implements OnInit {
  constructor(public authService: AuthService,
    private activatedRoute: ActivatedRoute,
    private router: Router,
    private myService: MyService,
    public lifeCommonService: LifeCommonService) {

    }
  MOBILE_REGEXP = /^(1)\d{10}$/;
  sendCodeHtml: string = '获取验证码';
  timer: any;
  remainTimes: number = 60;
  disabledSendBtn: boolean = false;
  userInfo: any = {
    name:null,
    mobileNo: null,
    verificationCode: null
  };
  isNeedAlert: boolean;
  dialogInfo: any;
  redirect: any;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  hiringBasicInfoId:any;
  // 判断是哪个注册页面
  type:string;
  // 分享电子告知书ID
  eNoticeId:string;
  // 电子告知书信息
  eNoticeInfo:any;
  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.eNoticeId = this.activatedRoute.snapshot.queryParams.eNoticeId?this.activatedRoute.snapshot.queryParams.eNoticeId:null;
    sessionStorage.setItem('eNoticeId',this.eNoticeId);
    this.type = this.activatedRoute.snapshot.routeConfig.path;
    console.log(this.type)
    if(this.type=='identify'){
      this.queryInformedSheetById();
    }
  }

  inputBlur() {
    window.scrollTo(0, 0);
  }

  // 查询告知书链接
  queryInformedSheetList(){
    this.myService.queryInformedSheetList({id:this.eNoticeId}).subscribe(res=>{
      if(res['success']){
        this.eNoticeInfo = res['data']['list'][0];
        if(this.eNoticeInfo['status']==1){
          if (this.lifeCommonService.checkDeviceType() == '1') {
            const newWindow = window.open();
            newWindow.location.href = this.eNoticeInfo['informedOssPath'];
          } else {
            window.location.href = this.eNoticeInfo['informedOssPath'];
          }
        }else{
          this.router.navigate(['/eNoticeSign']);
        }
      }else{
        this.openPopInfo(res['message']);
      }
    })
  }

    //  发送验证码
    verificationCode() {
      const verificationInfo = {
        mobileNo: this.userInfo.mobileNo,
        type: '1'
      };
      if (this.MOBILE_REGEXP.test(this.userInfo.mobileNo) && !this.disabledSendBtn) {
        this.authService.verificationCode(verificationInfo).subscribe(res => {
          if (res['success']) {
            this.countDown();
          } else {
            this.openPopInfo(res['message']);
          }
        });
      } else if (!this.MOBILE_REGEXP.test(this.userInfo.mobileNo)) {
        this.openPopInfo('手机号不正确');
      }
    }

    //  倒计时
    countDown() {
      this.disabledSendBtn = true;
      this.timer = setInterval(() => {
        this.remainTimes--;
        this.sendCodeHtml = `${this.remainTimes}(S)`;
        if (this.remainTimes <= 0) {
          this.sendCodeHtml = '获取验证码';
          this.remainTimes = 60;
          this.disabledSendBtn = false;
          clearInterval(this.timer);
        }
      }, 1000);
    }

    // 打开弹窗
    openPopInfo(message) {
      this.isNeedAlert = true;
      this.dialogInfo = {
        title: null,
        content: { value: message, align: 'center' },
        footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
      };
    }

   // 关闭弹窗
   getPopInfo() {
    this.isNeedAlert = false;
  }

  checkVerificationCode(){
    if(!this.userInfo.mobileNo){
      this.toastDialog = true;
      this.toastInfo = {
        status: 1,
        msg: '手机号不能为空！',
        timeout: 3000,
        align: 'center'
      };
      return;
    }
    if(!this.userInfo.verificationCode){
      this.toastDialog = true;
      this.toastInfo = {
        status: 1,
        msg: '验证码不能为空！',
        timeout: 3000,
        align: 'center'
      };
      return;
    }
    const compareCodeObj = {
      mobileNo: this.userInfo.mobileNo,
      verificationCode: this.userInfo.verificationCode,
      expireTime: '3600',
      fromSystemName:'ydLife'
    };
    this.authService.compare(compareCodeObj).subscribe((res)=>{
      if(res['success']){
        if(this.type=='identify'){
          this.queryInformedSheetList();
        }else{
          this.myService.queryWholeInfo({hiringBasicInfoId:this.hiringBasicInfoId}).subscribe((resp)=>{
            if(resp['success']){
              sessionStorage.setItem('inviteeCustomerId',resp['data']['customerId']);
              this.router.navigate(['/employee_info'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId,mobileNo:this.userInfo.mobileNo} });
            }else{
              this.openPopInfo(resp['message']);
            }
          })
        }
      }else{
        this.openPopInfo(res['message']);
      }
    })
  }

  // 通过ID获取用户信息
  queryInformedSheetById(){
    this.myService.queryInformedSheetById({'id':this.eNoticeId}).subscribe(res=>{
      console.log(res);
      if(res['success']){
        const informed = res['data']['informed'];
        this.userInfo = {
          name:informed.customerName,
          mobileNo: informed.customerMobile
        };
      }else{
        this.openPopInfo(res['message']);
      }
    })
  }
}
